/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminQueryBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminUpdateBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DatabaseAdminBackendHandlerFactory {
    public static Optional<ProxyBackendHandler> newInstance(DatabaseType databaseType, SQLStatementContext sqlStatementContext, ConnectionSession connectionSession) {
        Optional executorCreator = DatabaseTypedSPILoader.findService(DatabaseAdminExecutorCreator.class, (DatabaseType)databaseType);
        if (!executorCreator.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = ((DatabaseAdminExecutorCreator)executorCreator.get()).create(sqlStatementContext);
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createProxyBackendHandler(sqlStatementContext, connectionSession, optional));
    }

    public static Optional<ProxyBackendHandler> newInstance(DatabaseType databaseType, SQLStatementContext sqlStatementContext, ConnectionSession connectionSession, String sql, List<Object> parameters) {
        Optional executorCreator = DatabaseTypedSPILoader.findService(DatabaseAdminExecutorCreator.class, (DatabaseType)databaseType);
        if (!executorCreator.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = ((DatabaseAdminExecutorCreator)executorCreator.get()).create(sqlStatementContext, sql, connectionSession.getUsedDatabaseName(), parameters);
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createProxyBackendHandler(sqlStatementContext, connectionSession, optional));
    }

    private static ProxyBackendHandler createProxyBackendHandler(SQLStatementContext sqlStatementContext, ConnectionSession connectionSession, DatabaseAdminExecutor executor) {
        return executor instanceof DatabaseAdminQueryExecutor ? new DatabaseAdminQueryBackendHandler(connectionSession, (DatabaseAdminQueryExecutor)executor) : new DatabaseAdminUpdateBackendHandler(connectionSession, sqlStatementContext.getSqlStatement(), executor);
    }

    @Generated
    private DatabaseAdminBackendHandlerFactory() {
    }
}

