/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data;

import javax.annotation.concurrent.Immutable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.ImmutableEventData;

@Immutable
public interface EventData {
    public static EventData create(long epochNanos, String name, Attributes attributes) {
        return ImmutableEventData.create(epochNanos, name, attributes);
    }

    public static EventData create(long epochNanos, String name, Attributes attributes, int totalAttributeCount) {
        return ImmutableEventData.create(epochNanos, name, attributes, totalAttributeCount);
    }

    public String getName();

    public Attributes getAttributes();

    public long getEpochNanos();

    public int getTotalAttributeCount();

    default public int getDroppedAttributesCount() {
        return this.getTotalAttributeCount() - this.getAttributes().size();
    }
}

