/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.opengauss.packet.authentication;

import org.apache.shardingsphere.db.protocol.opengauss.constant.OpenGaussProtocolVersion;
import org.apache.shardingsphere.db.protocol.opengauss.packet.authentication.OpenGaussAuthenticationHexData;
import org.apache.shardingsphere.db.protocol.opengauss.packet.authentication.OpenGaussMacCalculator;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class OpenGaussAuthenticationSCRAMSha256Packet
extends PostgreSQLIdentifierPacket {
    private static final int AUTH_REQ_SHA256 = 10;
    private static final int PASSWORD_STORED_METHOD_SHA256 = 2;
    private final int version;
    private final int serverIteration;
    private final OpenGaussAuthenticationHexData authHexData;
    private final String serverSignature;

    public OpenGaussAuthenticationSCRAMSha256Packet(int version, int serverIteration, OpenGaussAuthenticationHexData authHexData, String password) {
        this.version = version;
        this.serverIteration = serverIteration;
        this.authHexData = authHexData;
        this.serverSignature = version >= OpenGaussProtocolVersion.PROTOCOL_350.getVersion() ? "" : OpenGaussMacCalculator.requestServerMac(password, authHexData, serverIteration);
    }

    protected void write(PostgreSQLPacketPayload payload) {
        payload.writeInt4(10);
        payload.writeInt4(2);
        payload.writeBytes(this.authHexData.getSalt().getBytes());
        payload.writeBytes(this.authHexData.getNonce().getBytes());
        if (this.version < OpenGaussProtocolVersion.PROTOCOL_350.getVersion()) {
            payload.writeBytes(this.serverSignature.getBytes());
        }
        if (OpenGaussProtocolVersion.PROTOCOL_351.getVersion() == this.version) {
            payload.writeInt4(this.serverIteration);
        }
    }

    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.AUTHENTICATION_REQUEST;
    }
}

