/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel.KernelSQLException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;

public final class ShadowRuleStatementChecker {
    public static void checkStorageUnitsExist(Collection<String> requiredStorageUnits, ShardingSphereDatabase database) {
        Collection notExistedStorageUnits = database.getResourceMetaData().getNotExistedDataSources(requiredStorageUnits);
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedStorageUnits, () -> new MissingRequiredStorageUnitsException(database.getName(), notExistedStorageUnits));
    }

    public static void checkDuplicated(Collection<String> rules, Function<Collection<String>, KernelSQLException> thrower) {
        Collection<String> duplicated = ShadowRuleStatementChecker.getDuplicated(rules);
        ShardingSpherePreconditions.checkMustEmpty(duplicated, () -> (KernelSQLException)thrower.apply(duplicated));
    }

    public static void checkDuplicated(Collection<String> requiredRules, Collection<String> currentRules, Function<Collection<String>, KernelSQLException> thrower) {
        Collection<String> duplicated = ShadowRuleStatementChecker.getDuplicated(requiredRules, currentRules);
        ShardingSpherePreconditions.checkMustEmpty(duplicated, () -> (KernelSQLException)thrower.apply(duplicated));
    }

    public static void checkExisted(Collection<String> requiredRules, Collection<String> currentRules, Function<Collection<String>, KernelSQLException> thrower) {
        Collection<String> notExisted = ShadowRuleStatementChecker.getNotExisted(requiredRules, currentRules);
        ShardingSpherePreconditions.checkMustEmpty(notExisted, () -> (KernelSQLException)thrower.apply(notExisted));
    }

    private static Collection<String> getDuplicated(Collection<String> names) {
        return names.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static Collection<String> getDuplicated(Collection<String> required, Collection<String> current) {
        return required.stream().filter(current::contains).collect(Collectors.toSet());
    }

    private static Collection<String> getNotExisted(Collection<String> required, Collection<String> current) {
        return required.stream().filter(each -> !current.contains(each)).collect(Collectors.toSet());
    }

    public static void checkDuplicatedWithLogicDataSource(Collection<String> toBeCreatedRuleNames, ShardingSphereDatabase database) {
        Collection<String> logicDataSources = ShadowRuleStatementChecker.getLogicDataSources(database);
        if (!logicDataSources.isEmpty()) {
            Collection duplicatedNames = toBeCreatedRuleNames.stream().filter(logicDataSources::contains).collect(Collectors.toList());
            ShardingSpherePreconditions.checkMustEmpty((Collection)duplicatedNames, () -> new InvalidRuleConfigurationException("shadow", duplicatedNames, Collections.singleton(String.format("%s already exists in storage unit", duplicatedNames))));
        }
    }

    private static Collection<String> getLogicDataSources(ShardingSphereDatabase database) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (DataSourceMapperRuleAttribute each : database.getRuleMetaData().getAttributes(DataSourceMapperRuleAttribute.class)) {
            result.addAll(each.getDataSourceMapper().keySet());
        }
        return result;
    }

    @Generated
    private ShadowRuleStatementChecker() {
    }
}

