/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.retriever.dml.table.column.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.column.ShadowColumnDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.util.ShadowExtractor;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;

public final class ShadowSelectStatementDataSourceMappingsRetriever
extends ShadowColumnDataSourceMappingsRetriever {
    private final SelectStatementContext sqlStatementContext;
    private final List<Object> parameters;

    public ShadowSelectStatementDataSourceMappingsRetriever(SelectStatementContext sqlStatementContext, List<Object> parameters) {
        super(ShadowOperationType.SELECT);
        this.sqlStatementContext = sqlStatementContext;
        this.parameters = parameters;
    }

    @Override
    protected Collection<ShadowColumnCondition> getShadowColumnConditions(String shadowColumnName) {
        LinkedList<ShadowColumnCondition> result = new LinkedList<ShadowColumnCondition>();
        for (ExpressionSegment each : this.getWhereSegment()) {
            Collection columns = ColumnExtractor.extract((ExpressionSegment)each);
            if (1 != columns.size()) continue;
            ShadowExtractor.extractValues(each, this.parameters).map(values -> new ShadowColumnCondition(((ColumnSegment)columns.iterator().next()).getColumnBoundInfo().getOriginalTable().getValue(), shadowColumnName, (Collection<Comparable<?>>)values)).ifPresent(result::add);
        }
        return result;
    }

    private Collection<ExpressionSegment> getWhereSegment() {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.sqlStatementContext.getWhereSegments()) {
            for (AndPredicate predicate : ExpressionExtractor.extractAndPredicates((ExpressionSegment)each.getExpr())) {
                result.addAll(predicate.getPredicates());
            }
        }
        return result;
    }
}

