/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.advice.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.core.advice.AbstractInstanceMethodAdvice;
import org.apache.shardingsphere.agent.plugin.core.recorder.MethodTimeRecorder;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.HistogramMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;

public abstract class AbstractExecuteLatencyHistogramAdvice
extends AbstractInstanceMethodAdvice {
    private final MetricConfiguration config = new MetricConfiguration("jdbc_statement_execute_latency_millis", MetricCollectorType.HISTOGRAM, "Statement execute latency millis histogram", Collections.singletonMap("buckets", this.getBuckets()));

    private Map<String, Object> getBuckets() {
        HashMap<String, Object> result = new HashMap<String, Object>(4, 1.0f);
        result.put("type", "exp");
        result.put("start", 1);
        result.put("factor", 2);
        result.put("count", 13);
        return result;
    }

    public void beforeMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, String pluginType) {
        this.getMethodTimeRecorder().recordNow(method);
    }

    public void afterMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, Object result, String pluginType) {
        ((HistogramMetricsCollector)MetricsCollectorRegistry.get(this.config, pluginType)).observe(this.getMethodTimeRecorder().getElapsedTimeAndClean(method));
    }

    protected abstract MethodTimeRecorder getMethodTimeRecorder();
}

