/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.strategy.type.standard;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.datanode.DataNodeInfo;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.metadata.MissingRequiredShardingConfigurationException;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategy;

public final class StandardShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final StandardShardingAlgorithm<?> shardingAlgorithm;

    public StandardShardingStrategy(String shardingColumn, StandardShardingAlgorithm<?> shardingAlgorithm) {
        ShardingSpherePreconditions.checkNotNull((Object)shardingColumn, () -> new MissingRequiredShardingConfigurationException("Standard sharding column"));
        ShardingSpherePreconditions.checkNotNull(shardingAlgorithm, () -> new MissingRequiredShardingConfigurationException("Standard sharding algorithm"));
        TreeSet<String> shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        shardingColumns.add(shardingColumn);
        this.shardingColumns = Collections.unmodifiableCollection(shardingColumns);
        this.shardingAlgorithm = shardingAlgorithm;
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingConditionValue> shardingConditionValues, DataNodeInfo dataNodeInfo, ConfigurationProperties props) {
        ShardingConditionValue shardingConditionValue = shardingConditionValues.iterator().next();
        Collection<String> shardingResult = shardingConditionValue instanceof ListShardingConditionValue ? this.doSharding(availableTargetNames, (ListShardingConditionValue)shardingConditionValue, dataNodeInfo) : this.doSharding(availableTargetNames, (RangeShardingConditionValue)shardingConditionValue, dataNodeInfo);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, ListShardingConditionValue<?> shardingValue, DataNodeInfo dataNodeInfo) {
        LinkedList<String> result = new LinkedList<String>();
        for (Object each : shardingValue.getValues()) {
            String target = this.shardingAlgorithm.doSharding(availableTargetNames, new PreciseShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), dataNodeInfo, each));
            if (null == target || !availableTargetNames.contains(target)) continue;
            result.add(target);
        }
        return result;
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingConditionValue<?> shardingValue, DataNodeInfo dataNodeInfo) {
        return this.shardingAlgorithm.doSharding(availableTargetNames, new RangeShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), dataNodeInfo, shardingValue.getValueRange()));
    }

    @Override
    @Generated
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }

    @Generated
    public StandardShardingAlgorithm<?> getShardingAlgorithm() {
        return this.shardingAlgorithm;
    }
}

