/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.reflection;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.Generated;

public final class ReflectionUtils {
    private static final String GETTER_PREFIX = "get";

    public static <T> Optional<T> getFieldValue(Object target, String fieldName) {
        return ReflectionUtils.findField(fieldName, target.getClass()).map(optional -> ReflectionUtils.getFieldValue(target, optional));
    }

    private static <T> T getFieldValue(Object target, Field field) {
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object result = field.get(target);
        if (!accessible) {
            field.setAccessible(false);
        }
        return (T)result;
    }

    private static Optional<Field> findField(String fieldName, Class<?> targetClass) {
        for (Class<?> currentTargetClass = targetClass; Object.class != currentTargetClass; currentTargetClass = currentTargetClass.getSuperclass()) {
            try {
                return Optional.of(currentTargetClass.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException ignored) {
                continue;
            }
        }
        return Optional.empty();
    }

    public static <T> T getStaticFieldValue(Class<?> target, String fieldName) {
        Field field = target.getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object result = field.get(target);
        if (!accessible) {
            field.setAccessible(false);
        }
        return (T)result;
    }

    public static void setStaticFieldValue(Class<?> target, String fieldName, Object value) {
        Field field = target.getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        field.set(target, value);
        if (!accessible) {
            field.setAccessible(false);
        }
    }

    public static <T> T invokeMethod(Method method, Object target, Object ... args) {
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        Object result = method.invoke(target, args);
        if (!accessible) {
            method.setAccessible(false);
        }
        return (T)result;
    }

    public static <T> Optional<T> getFieldValueByGetMethod(Object target, String fieldName) {
        String getterName = GETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
        Optional<Method> method = ReflectionUtils.findMethod(target.getClass(), getterName, new Class[0]);
        if (method.isPresent()) {
            T value = ReflectionUtils.invokeMethod(method.get(), target, new Object[0]);
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    private static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return Optional.of(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException ex) {
            Class<?> superclass = clazz.getSuperclass();
            if (null != superclass && Object.class != superclass) {
                return ReflectionUtils.findMethod(superclass, methodName, parameterTypes);
            }
            return Optional.empty();
        }
    }

    @Generated
    private ReflectionUtils() {
    }
}

