/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.oracle.metadata.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;

public final class OracleDatabaseMetaData
implements DialectDatabaseMetaData {
    private static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "START", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"));

    public QuoteCharacter getQuoteCharacter() {
        return QuoteCharacter.QUOTE;
    }

    public NullsOrderType getDefaultNullsOrderType() {
        return NullsOrderType.HIGH;
    }

    public boolean isReservedWord(String identifier) {
        return RESERVED_KEYWORDS.contains(identifier.toUpperCase());
    }

    public boolean isSchemaAvailable() {
        return true;
    }

    public String getSchema(Connection connection) {
        try {
            return Optional.ofNullable(connection.getMetaData().getUserName()).map(String::toUpperCase).orElse(null);
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    public String formatTableNamePattern(String tableNamePattern) {
        return tableNamePattern.toUpperCase();
    }

    public boolean isInstanceConnectionAvailable() {
        return true;
    }

    public String getDatabaseType() {
        return "Oracle";
    }

    public Map<String, Integer> getExtraDataTypes() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(8);
        result.put("SMALLINT", 5);
        result.put("TINYINT", -6);
        result.put("INT", 4);
        result.put("TEXT", -1);
        result.put("CHARACTER", 1);
        result.put("VARCHAR2", 12);
        result.put("DATETIME", 93);
        result.put("ROWID", -8);
        result.put("BINARY_DOUBLE", 8);
        result.put("BINARY_FLOAT", 6);
        result.put("NUMBER", 2);
        return result;
    }
}

