/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.ddl;

import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.AlterIndexStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.kernel.metadata.DuplicateIndexException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.IndexNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.checker.sql.util.ShardingSupportedCheckUtils;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterIndexStatement;

public final class ShardingAlterIndexSupportedChecker
implements SupportedSQLChecker<AlterIndexStatementContext, ShardingRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof AlterIndexStatementContext;
    }

    public void check(ShardingRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, AlterIndexStatementContext sqlStatementContext) {
        AlterIndexStatement alterIndexStatement = sqlStatementContext.getSqlStatement();
        Optional index = alterIndexStatement.getIndex();
        ShardingSphereSchema schema = index.flatMap(optional -> optional.getOwner().map(owner -> database.getSchema(owner.getIdentifier().getValue()))).orElse(currentSchema);
        if (index.isPresent() && !ShardingSupportedCheckUtils.isSchemaContainsIndex(schema, (IndexSegment)index.get())) {
            throw new IndexNotFoundException(((IndexSegment)index.get()).getIndexName().getIdentifier().getValue());
        }
        Optional renameIndex = alterIndexStatement.getRenameIndex();
        if (renameIndex.isPresent() && ShardingSupportedCheckUtils.isSchemaContainsIndex(schema, (IndexSegment)renameIndex.get())) {
            throw new DuplicateIndexException(((IndexSegment)renameIndex.get()).getIndexName().getIdentifier().getValue());
        }
    }
}

