/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ShardingSphereDataNodePath {
    private static final String ROOT_NODE = "/statistics";
    private static final String DATABASES_NODE = "databases";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String TABLES_NODE = "tables";
    private static final String JOB_NODE = "job";
    private static final String IDENTIFIER_PATTERN = "([\\w\\-]+)";
    private static final String UNIQUE_KEY_PATTERN = "(\\w+)";

    public static String getDatabasesRootPath() {
        return String.join((CharSequence)"/", ROOT_NODE, DATABASES_NODE);
    }

    public static String getDatabasePath(String databaseName) {
        return String.join((CharSequence)"/", ShardingSphereDataNodePath.getDatabasesRootPath(), databaseName);
    }

    public static String getSchemaRootPath(String databaseName) {
        return String.join((CharSequence)"/", ShardingSphereDataNodePath.getDatabasePath(databaseName), SCHEMAS_NODE);
    }

    public static String getSchemaPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ShardingSphereDataNodePath.getSchemaRootPath(databaseName), schemaName);
    }

    public static String getTableRootPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ShardingSphereDataNodePath.getSchemaPath(databaseName, schemaName), TABLES_NODE);
    }

    public static String getTablePath(String databaseName, String schemaName, String tableName) {
        return String.join((CharSequence)"/", ShardingSphereDataNodePath.getTableRootPath(databaseName, schemaName), tableName);
    }

    public static String getTableRowPath(String databaseName, String schemaName, String tableName, String uniqueKey) {
        return String.join((CharSequence)"/", ShardingSphereDataNodePath.getTablePath(databaseName, schemaName, tableName), uniqueKey);
    }

    public static Optional<String> findDatabaseName(String path, boolean containsChildPath) {
        String endPattern = containsChildPath ? "?" : "$";
        Pattern pattern = Pattern.compile(ShardingSphereDataNodePath.getDatabasePath(IDENTIFIER_PATTERN) + endPattern, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> findSchemaName(String path, boolean containsChildPath) {
        String endPattern = containsChildPath ? "?" : "$";
        Pattern pattern = Pattern.compile(ShardingSphereDataNodePath.getSchemaPath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN) + endPattern, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> findTableName(String path, boolean containsChildPath) {
        String endPattern = containsChildPath ? "?" : "$";
        Pattern pattern = Pattern.compile(ShardingSphereDataNodePath.getTablePath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN, IDENTIFIER_PATTERN) + endPattern, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> findRowUniqueKey(String path) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNodePath.getTableRowPath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN, IDENTIFIER_PATTERN, UNIQUE_KEY_PATTERN) + "$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(4)) : Optional.empty();
    }

    public static String getJobPath() {
        return String.join((CharSequence)"/", ROOT_NODE, JOB_NODE);
    }

    @Generated
    private ShardingSphereDataNodePath() {
    }
}

