/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export;

import java.util.Objects;
import java.util.StringJoiner;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;

@FunctionalInterface
public interface DefaultAggregationSelector {
    public static DefaultAggregationSelector getDefault() {
        return instrumentType -> Aggregation.defaultAggregation();
    }

    default public DefaultAggregationSelector with(InstrumentType instrumentType, Aggregation aggregation) {
        Objects.requireNonNull(instrumentType, "instrumentType");
        Objects.requireNonNull(aggregation, "aggregation");
        return instrumentType1 -> {
            if (instrumentType1 == instrumentType) {
                return aggregation;
            }
            return this.getDefaultAggregation(instrumentType1);
        };
    }

    public Aggregation getDefaultAggregation(InstrumentType var1);

    public static String asString(DefaultAggregationSelector selector) {
        StringJoiner joiner = new StringJoiner(", ", "DefaultAggregationSelector{", "}");
        for (InstrumentType type : InstrumentType.values()) {
            joiner.add(type.name() + "=" + AggregationUtil.aggregationName(selector.getDefaultAggregation(type)));
        }
        return joiner.toString();
    }
}

