/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.ReportLocalProcessesCompletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.ReportLocalProcessesEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;

public final class ShowProcessListDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return ComputeNode.getShowProcessListTriggerNodePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        return this.createReportLocalProcessesEvent(event);
    }

    private Optional<DispatchEvent> createReportLocalProcessesEvent(DataChangedEvent event) {
        Matcher matcher = this.getShowProcessListTriggerMatcher(event);
        if (!matcher.find()) {
            return Optional.empty();
        }
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            return Optional.of(new ReportLocalProcessesEvent(matcher.group(1), matcher.group(2)));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new ReportLocalProcessesCompletedEvent(matcher.group(2)));
        }
        return Optional.empty();
    }

    private Matcher getShowProcessListTriggerMatcher(DataChangedEvent event) {
        return Pattern.compile(ComputeNode.getShowProcessListTriggerNodePath() + "/([\\S]+):([\\S]+)$", 2).matcher(event.getKey());
    }
}

