/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.index;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterIndexStatement;

public final class AlterIndexStatementSchemaRefresher
implements MetaDataRefresher<AlterIndexStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, AlterIndexStatement sqlStatement, ConfigurationProperties props) {
        Optional renameIndex = sqlStatement.getRenameIndex();
        if (!sqlStatement.getIndex().isPresent() || !renameIndex.isPresent()) {
            return;
        }
        String actualSchemaName = ((IndexSegment)sqlStatement.getIndex().get()).getOwner().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElse(schemaName);
        String indexName = ((IndexSegment)sqlStatement.getIndex().get()).getIndexName().getIdentifier().getValue();
        Optional<String> logicTableName = this.findLogicTableName(database.getSchema(actualSchemaName), indexName);
        Preconditions.checkState((boolean)logicTableName.isPresent(), (String)"Can not find logic table by index '%s' of schema '%s'.", (Object)indexName, (Object)schemaName);
        ShardingSphereTable table = database.getSchema(actualSchemaName).getTable(logicTableName.get());
        Preconditions.checkNotNull((Object)table, (String)"Can not get the table '%s' meta data!", (Object)logicTableName.get());
        ShardingSphereTable newTable = this.newShardingSphereTable(table);
        newTable.removeIndex(indexName);
        String renameIndexName = ((IndexSegment)renameIndex.get()).getIndexName().getIdentifier().getValue();
        newTable.putIndex(new ShardingSphereIndex(renameIndexName));
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), actualSchemaName);
        alterSchemaMetaDataPOJO.getAlteredTables().add(newTable);
        metaDataManagerPersistService.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String indexName) {
        return schema.getAllTableNames().stream().filter(each -> schema.getTable(each).containsIndex(indexName)).findFirst();
    }

    private ShardingSphereTable newShardingSphereTable(ShardingSphereTable table) {
        ShardingSphereTable result = new ShardingSphereTable(table.getName(), table.getColumnValues(), table.getIndexValues(), table.getConstraintValues(), table.getType());
        result.getColumnNames().addAll(table.getColumnNames());
        result.getVisibleColumns().addAll(table.getVisibleColumns());
        result.getPrimaryKeyColumns().addAll(table.getPrimaryKeyColumns());
        return result;
    }

    @Override
    public Class<AlterIndexStatement> getType() {
        return AlterIndexStatement.class;
    }
}

