/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.PartialRuleUpdateSupported;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRulesBuilder;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class DatabaseRuleConfigurationManager {
    private final AtomicReference<MetaDataContexts> metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final MetaDataPersistService metaDataPersistService;

    public DatabaseRuleConfigurationManager(AtomicReference<MetaDataContexts> metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public synchronized void alterRuleConfiguration(String databaseName, RuleConfiguration ruleConfig) throws SQLException {
        ShardingSphereDatabase database = this.metaDataContexts.get().getMetaData().getDatabase(databaseName);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(database.getRuleMetaData().getRules());
        Optional<ShardingSphereRule> toBeChangedRule = rules.stream().filter(each -> each.getConfiguration().getClass().equals(ruleConfig.getClass())).findFirst();
        if (toBeChangedRule.isPresent() && toBeChangedRule.get() instanceof PartialRuleUpdateSupported && ((PartialRuleUpdateSupported)toBeChangedRule.get()).partialUpdate(ruleConfig)) {
            ((PartialRuleUpdateSupported)toBeChangedRule.get()).updateConfiguration(ruleConfig);
            return;
        }
        rules.removeIf(each -> each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass()));
        rules.addAll(DatabaseRulesBuilder.build((String)databaseName, (DatabaseType)database.getProtocolType(), (Collection)database.getRuleMetaData().getRules(), (RuleConfiguration)ruleConfig, (ComputeNodeInstanceContext)this.computeNodeInstanceContext, (ResourceMetaData)database.getResourceMetaData()));
        this.refreshMetadata(databaseName, database, rules);
    }

    public synchronized void dropRuleConfiguration(String databaseName, RuleConfiguration ruleConfig) throws SQLException {
        ShardingSphereDatabase database = this.metaDataContexts.get().getMetaData().getDatabase(databaseName);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(database.getRuleMetaData().getRules());
        Optional<ShardingSphereRule> toBeChangedRule = rules.stream().filter(each -> each.getConfiguration().getClass().equals(ruleConfig.getClass())).findFirst();
        if (toBeChangedRule.isPresent() && toBeChangedRule.get() instanceof PartialRuleUpdateSupported && ((PartialRuleUpdateSupported)toBeChangedRule.get()).partialUpdate(ruleConfig)) {
            ((PartialRuleUpdateSupported)toBeChangedRule.get()).updateConfiguration(ruleConfig);
            return;
        }
        rules.removeIf(each -> each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass()));
        if (!((DatabaseRuleConfiguration)ruleConfig).isEmpty()) {
            rules.addAll(DatabaseRulesBuilder.build((String)databaseName, (DatabaseType)database.getProtocolType(), (Collection)database.getRuleMetaData().getRules(), (RuleConfiguration)ruleConfig, (ComputeNodeInstanceContext)this.computeNodeInstanceContext, (ResourceMetaData)database.getResourceMetaData()));
        }
        this.refreshMetadata(databaseName, database, rules);
    }

    private void refreshMetadata(String databaseName, ShardingSphereDatabase database, Collection<ShardingSphereRule> rules) throws SQLException {
        database.getRuleMetaData().getRules().clear();
        database.getRuleMetaData().getRules().addAll(rules);
        MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createByAlterRule(databaseName, false, database.getRuleMetaData().getConfigurations(), this.metaDataContexts.get(), this.metaDataPersistService, this.computeNodeInstanceContext);
        this.metaDataContexts.set(reloadMetaDataContexts);
        this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getSchemas().putAll(this.buildShardingSphereSchemas(this.metaDataContexts.get().getMetaData().getDatabase(databaseName)));
    }

    private Map<String, ShardingSphereSchema> buildShardingSphereSchemas(ShardingSphereDatabase database) {
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(database.getSchemas().size(), 1.0f);
        database.getSchemas().forEach((key, value) -> result.put((String)key, new ShardingSphereSchema(key, value.getTables(), value.getViews())));
        return result;
    }
}

