/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.context.planner;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.schema.Schema;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sqlfederation.optimizer.context.planner.OptimizerMetaData;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.SQLFederationSchema;

public final class OptimizerMetaDataFactory {
    private static final JavaTypeFactory DEFAULT_DATA_TYPE_FACTORY = new JavaTypeFactoryImpl();

    public static Map<String, OptimizerMetaData> create(Map<String, ShardingSphereDatabase> databases) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(databases.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereDatabase> entry : databases.entrySet()) {
            result.put(entry.getKey(), OptimizerMetaDataFactory.create(entry.getValue()));
        }
        return result;
    }

    public static OptimizerMetaData create(ShardingSphereDatabase database) {
        CaseInsensitiveMap schemas = new CaseInsensitiveMap();
        for (Map.Entry entry : database.getSchemas().entrySet()) {
            SQLFederationSchema sqlFederationSchema = new SQLFederationSchema((String)entry.getKey(), (ShardingSphereSchema)entry.getValue(), database.getProtocolType(), DEFAULT_DATA_TYPE_FACTORY);
            schemas.put((String)entry.getKey(), sqlFederationSchema);
        }
        return new OptimizerMetaData((Map<String, Schema>)schemas);
    }

    @Generated
    private OptimizerMetaDataFactory() {
    }
}

