/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.config.global;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class PropertiesPersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public Properties load() {
        String yamlContent = this.repository.query(GlobalNode.getPropsVersionNode(this.getActiveVersion()));
        return Strings.isNullOrEmpty((String)yamlContent) ? new Properties() : (Properties)YamlEngine.unmarshal((String)yamlContent, Properties.class);
    }

    public void persist(Properties props) {
        List versions = this.repository.getChildrenKeys(GlobalNode.getPropsVersionsNode());
        String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt((String)versions.get(0)) + 1);
        this.repository.persist(GlobalNode.getPropsVersionNode(nextActiveVersion), YamlEngine.marshal((Object)props));
        if (Strings.isNullOrEmpty((String)this.getActiveVersion())) {
            this.repository.persist(GlobalNode.getPropsActiveVersionNode(), "0");
        }
        this.metaDataVersionPersistService.switchActiveVersion(Collections.singleton(new MetaDataVersion(GlobalNode.getPropsRootNode(), this.getActiveVersion(), nextActiveVersion)));
    }

    private String getActiveVersion() {
        return this.repository.query(GlobalNode.getPropsActiveVersionNode());
    }

    @Generated
    public PropertiesPersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.metaDataVersionPersistService = metaDataVersionPersistService;
    }
}

