/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule.column.item;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;

public final class CipherColumnItem {
    private final String name;
    private final EncryptAlgorithm encryptor;

    public Object encrypt(String databaseName, String schemaName, String tableName, String logicColumnName, Object originalValue) {
        if (null == originalValue) {
            return null;
        }
        return this.encryptor.encrypt(originalValue, new AlgorithmSQLContext(databaseName, schemaName, tableName, logicColumnName));
    }

    public List<Object> encrypt(String databaseName, String schemaName, String tableName, String logicColumnName, List<Object> originalValues) {
        AlgorithmSQLContext algorithmSQLContext = new AlgorithmSQLContext(databaseName, schemaName, tableName, logicColumnName);
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            result.add(null == each ? null : this.encryptor.encrypt(each, algorithmSQLContext));
        }
        return result;
    }

    public Object decrypt(String databaseName, String schemaName, String tableName, String logicColumnName, Object cipherValue) {
        if (null == cipherValue) {
            return null;
        }
        return this.encryptor.decrypt(cipherValue, new AlgorithmSQLContext(databaseName, schemaName, tableName, logicColumnName));
    }

    @Generated
    public CipherColumnItem(String name, EncryptAlgorithm encryptor) {
        this.name = name;
        this.encryptor = encryptor;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public EncryptAlgorithm getEncryptor() {
        return this.encryptor;
    }
}

