/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.comparator;

import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.comparator.EncryptorComparator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class InsertSelectColumnsEncryptorComparator {
    public static boolean isSame(Collection<ColumnSegment> insertColumns, Collection<Projection> projections, EncryptRule encryptRule) {
        Iterator<ColumnSegment> insertColumnsIterator = insertColumns.iterator();
        Iterator<Projection> projectionIterator = projections.iterator();
        while (insertColumnsIterator.hasNext()) {
            Projection projection;
            ColumnSegmentBoundInfo projectionColumnBoundInfo;
            EncryptAlgorithm projectionEncryptor;
            ColumnSegment insertColumnSegment = insertColumnsIterator.next();
            EncryptAlgorithm insertColumnEncryptor = encryptRule.findQueryEncryptor(insertColumnSegment.getColumnBoundInfo().getOriginalTable().getValue(), insertColumnSegment.getColumnBoundInfo().getOriginalColumn().getValue()).orElse(null);
            if (EncryptorComparator.isSame(insertColumnEncryptor, projectionEncryptor = (EncryptAlgorithm)encryptRule.findQueryEncryptor((projectionColumnBoundInfo = InsertSelectColumnsEncryptorComparator.getColumnSegmentBoundInfo(projection = projectionIterator.next())).getOriginalTable().getValue(), projectionColumnBoundInfo.getOriginalColumn().getValue()).orElse(null))) continue;
            return false;
        }
        return true;
    }

    private static ColumnSegmentBoundInfo getColumnSegmentBoundInfo(Projection projection) {
        return projection instanceof ColumnProjection ? new ColumnSegmentBoundInfo(null, null, ((ColumnProjection)projection).getOriginalTable(), ((ColumnProjection)projection).getOriginalColumn()) : new ColumnSegmentBoundInfo(new IdentifierValue(projection.getColumnLabel()));
    }

    @Generated
    private InsertSelectColumnsEncryptorComparator() {
    }
}

