/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.complex;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.metadata.ShardingTableRuleNotFoundException;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.complex.ShardingCartesianRoutingEngine;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRoutingEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingComplexRoutingEngine
implements ShardingRouteEngine {
    private final ShardingConditions shardingConditions;
    private final SQLStatementContext sqlStatementContext;
    private final HintValueContext hintValueContext;
    private final ConfigurationProperties props;
    private final Collection<String> logicTables;

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        TreeSet bindingTableNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        LinkedList<RouteContext> routeContexts = new LinkedList<RouteContext>();
        for (String each : this.logicTables) {
            Optional<ShardingTable> shardingTable = shardingRule.findShardingTable(each);
            if (!shardingTable.isPresent()) continue;
            if (!bindingTableNames.contains(each)) {
                routeContexts.add(new ShardingStandardRoutingEngine(shardingTable.get().getLogicTable(), this.shardingConditions, this.sqlStatementContext, this.hintValueContext, this.props).route(shardingRule));
            }
            shardingRule.findBindingTableRule(each).ifPresent(optional -> bindingTableNames.addAll(optional.getShardingTables().keySet()));
        }
        if (routeContexts.isEmpty()) {
            throw new ShardingTableRuleNotFoundException(this.logicTables);
        }
        RouteContext result = new RouteContext();
        if (1 == routeContexts.size()) {
            RouteContext newRouteContext = (RouteContext)routeContexts.iterator().next();
            result.getOriginalDataNodes().addAll(newRouteContext.getOriginalDataNodes());
            result.getRouteUnits().addAll(newRouteContext.getRouteUnits());
        } else {
            RouteContext routeContext = new ShardingCartesianRoutingEngine(routeContexts).route(shardingRule);
            result.getOriginalDataNodes().addAll(routeContext.getOriginalDataNodes());
            result.getRouteUnits().addAll(routeContext.getRouteUnits());
        }
        return result;
    }

    @Generated
    public ShardingComplexRoutingEngine(ShardingConditions shardingConditions, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, ConfigurationProperties props, Collection<String> logicTables) {
        this.shardingConditions = shardingConditions;
        this.sqlStatementContext = sqlStatementContext;
        this.hintValueContext = hintValueContext;
        this.props = props;
        this.logicTables = logicTables;
    }
}

