/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElmClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElmClientCodegen.class);
    private Set<String> customPrimitives = new HashSet<String>();
    private ElmVersion elmVersion = ElmVersion.ELM_019;
    private Boolean elmPrefixCustomTypeVariants = false;
    private static final String ELM_VERSION = "elmVersion";
    private static final String ELM_PREFIX_CUSTOM_TYPE_VARIANTS = "elmPrefixCustomTypeVariants";
    private static final String ELM_ENABLE_CUSTOM_BASE_PATHS = "elmEnableCustomBasePaths";
    private static final String ELM_ENABLE_HTTP_REQUEST_TRACKERS = "elmEnableHttpRequestTrackers";
    private static final String ENCODER = "elmEncoder";
    private static final String DECODER = "elmDecoder";
    private static final String DISCRIMINATOR_NAME = "discriminatorName";
    private static final String CUSTOM_TYPE = "elmCustomType";
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "elm";
    }

    @Override
    public String getHelp() {
        return "Generates a Elm client library (beta).";
    }

    public ElmClientCodegen() {
        this.outputFolder = "generated-code/elm";
        this.modelTemplateFiles.put("model.mustache", ".elm");
        this.templateDir = "elm";
        this.supportsInheritance = true;
        this.reservedWords = new HashSet<String>(Arrays.asList("if", "then", "else", "case", "of", "let", "in", "type", "module", "where", "import", "exposing", "as", "port"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Order", "Never", "List", "Maybe", "Result", "Program", "Cmd", "Sub"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "Dict", "Float", "Int", "List", "String"));
        this.customPrimitives = new HashSet<String>(Arrays.asList("Byte", "DateOnly", "DateTime", "Uuid"));
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Dict");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Int");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("date", "DateOnly");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("ByteArray", "Byte");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("UUID", "Uuid");
        this.typeMapping.put("URI", "String");
        this.importMapping.clear();
        this.cliOptions.clear();
        CliOption elmVersion = new CliOption(ELM_VERSION, "Elm version: 0.18, 0.19").defaultValue("0.19");
        HashMap<String, String> supportedVersions = new HashMap<String, String>();
        supportedVersions.put("0.18", "Elm 0.18");
        supportedVersions.put("0.19", "Elm 0.19");
        elmVersion.setEnum(supportedVersions);
        this.cliOptions.add(elmVersion);
        CliOption elmPrefixCustomTypeVariants = CliOption.newBoolean(ELM_PREFIX_CUSTOM_TYPE_VARIANTS, "Prefix custom type variants");
        this.cliOptions.add(elmPrefixCustomTypeVariants);
        CliOption elmEnableCustomBasePaths = CliOption.newBoolean(ELM_ENABLE_CUSTOM_BASE_PATHS, "Enable setting the base path for each request");
        this.cliOptions.add(elmEnableCustomBasePaths);
        CliOption elmEnableHttpRequestTrackers = CliOption.newBoolean(ELM_ENABLE_HTTP_REQUEST_TRACKERS, "Enable adding a tracker to each http request");
        this.cliOptions.add(elmEnableHttpRequestTrackers);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(ELM_VERSION)) {
            String version = (String)this.additionalProperties.get(ELM_VERSION);
            this.elmVersion = "0.18".equals(version) ? ElmVersion.ELM_018 : ElmVersion.ELM_019;
        }
        if (this.additionalProperties.containsKey(ELM_PREFIX_CUSTOM_TYPE_VARIANTS)) {
            this.elmPrefixCustomTypeVariants = Boolean.TRUE.equals(Boolean.valueOf(this.additionalProperties.get(ELM_PREFIX_CUSTOM_TYPE_VARIANTS).toString()));
        }
        if (this.additionalProperties.containsKey(ELM_ENABLE_CUSTOM_BASE_PATHS)) {
            boolean enable = Boolean.TRUE.equals(Boolean.valueOf(this.additionalProperties.get(ELM_ENABLE_CUSTOM_BASE_PATHS).toString()));
            this.additionalProperties.put("enableCustomBasePaths", enable);
        }
        if (this.additionalProperties.containsKey(ELM_ENABLE_HTTP_REQUEST_TRACKERS)) {
            boolean enable = Boolean.TRUE.equals(Boolean.valueOf(this.additionalProperties.get(ELM_ENABLE_HTTP_REQUEST_TRACKERS).toString()));
            this.additionalProperties.put("enableHttpRequestTrackers", enable);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("ELM_POST_PROCESS_FILE"))) {
            if (this.elmVersion.equals((Object)ElmVersion.ELM_018)) {
                LOGGER.info("Environment variable ELM_POST_PROCESS_FILE not defined so the Elm code may not be properly formatted. To define it, try `export ELM_POST_PROCESS_FILE=\"/usr/local/bin/elm-format --elm-version={} --yes\"` (Linux/Mac)", (Object)"0.18");
            } else {
                LOGGER.info("Environment variable ELM_POST_PROCESS_FILE not defined so the Elm code may not be properly formatted. To define it, try `export ELM_POST_PROCESS_FILE=\"/usr/local/bin/elm-format --elm-version={} --yes\"` (Linux/Mac)", (Object)"0.19");
            }
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        switch (this.elmVersion) {
            case ELM_018: {
                LOGGER.info("Elm version: 0.18");
                this.additionalProperties.put("isElm018", true);
                this.apiTemplateFiles.put("api018.mustache", ".elm");
                this.supportingFiles.add(new SupportingFile("DateOnly018.mustache", "src", "DateOnly.elm"));
                this.supportingFiles.add(new SupportingFile("DateTime018.mustache", "src", "DateTime.elm"));
                this.supportingFiles.add(new SupportingFile("elm-package018.mustache", "", "elm-package.json"));
                this.supportingFiles.add(new SupportingFile("Main018.mustache", "src", "Main.elm"));
                break;
            }
            case ELM_019: {
                LOGGER.info("Elm version: 0.19");
                this.additionalProperties.put("isElm019", true);
                this.apiTemplateFiles.put("api.mustache", ".elm");
                this.supportingFiles.add(new SupportingFile("DateOnly.mustache", "src", "DateOnly.elm"));
                this.supportingFiles.add(new SupportingFile("DateTime.mustache", "src", "DateTime.elm"));
                this.supportingFiles.add(new SupportingFile("elm.mustache", "", "elm.json"));
                this.supportingFiles.add(new SupportingFile("Main.mustache", "src", "Main.elm"));
                break;
            }
            default: {
                throw new RuntimeException("Undefined Elm version");
            }
        }
        this.supportingFiles.add(new SupportingFile("Byte.mustache", "src", "Byte.elm"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelName(String name) {
        String modelName = StringUtils.camelize(name);
        return this.defaultIncludes.contains(modelName) ? modelName + "_" : modelName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.toModelName(property.name);
    }

    @Override
    public String toVarName(String name) {
        String varName = StringUtils.camelize(name, true);
        return this.isReservedWord(varName) ? this.escapeReservedWord(name) : varName;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String camelized = StringUtils.camelize(value.replace(" ", "_").replace("(", "_").replace(")", ""));
        if (camelized.length() == 0) {
            LOGGER.error("Unable to determine enum variable name (name: {}, datatype: {}) from empty string. Default to UnknownEnumVariableName", (Object)value, (Object)datatype);
            camelized = "UnknownEnumVariableName";
        }
        if (!Character.isUpperCase(camelized.charAt(0))) {
            return "N" + camelized;
        }
        return camelized;
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return (String)this.instantiationTypes.get("array") + " " + inner;
        }
        return null;
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + ("/src/Request/" + this.apiPackage().replace('.', File.separatorChar)).replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + ("/src/Data/" + this.modelPackage().replace('.', File.separatorChar)).replace("/", File.separator);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        CodegenModel m = super.fromModel(name, schema);
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema am = (ArraySchema)schema;
            CodegenProperty codegenProperty = this.fromProperty(name, am.getItems());
            m.vendorExtensions.putAll(codegenProperty.vendorExtensions);
        }
        return m;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                allModels.put(modelName, cm);
            }
        }
        for (CodegenModel cm : allModels.values()) {
            CodegenModel parent = (CodegenModel)allModels.get(cm.parent);
            if (parent == null) continue;
            if (parent.children == null) {
                parent.children = new ArrayList<CodegenModel>();
                parent.hasChildren = true;
            }
            parent.children.add(cm);
            Collections.sort(parent.children, new Comparator<CodegenModel>(){

                @Override
                public int compare(CodegenModel cm1, CodegenModel cm2) {
                    return Collator.getInstance(Locale.ROOT).compare(cm1.classname, cm2.classname);
                }
            });
        }
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                ElmImport elmImport;
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (cm.isEnum) {
                    this.addEncoderAndDecoder(cm.vendorExtensions, cm.classname, DataTypeExposure.EXPOSED);
                    cm.vendorExtensions.put(CUSTOM_TYPE, cm.classname);
                } else if (cm.isAlias) {
                    this.addEncoderAndDecoder(cm.vendorExtensions, cm.dataType, DataTypeExposure.EXPOSED);
                }
                ArrayList<ElmImport> elmImports = new ArrayList<ElmImport>();
                for (CodegenProperty property : cm.allVars) {
                    if (property.complexType == null) continue;
                    elmImport = this.createImport(property.complexType);
                    elmImports.add(elmImport);
                }
                if (cm.isArrayModel && cm.arrayModelType != null) {
                    ElmImport elmImport2 = this.createImport(cm.arrayModelType);
                    elmImports.add(elmImport2);
                }
                if (cm.discriminator != null) {
                    for (CodegenModel child : cm.children) {
                        elmImport = this.createImport(child.classname);
                        elmImports.add(elmImport);
                        String propertyName = cm.discriminator.getPropertyName();
                        List allVars = child.allVars.stream().filter(var -> !var.baseName.equals(propertyName)).collect(Collectors.toList());
                        child.allVars.clear();
                        child.allVars.addAll(allVars);
                        child.vendorExtensions.put(DISCRIMINATOR_NAME, propertyName);
                    }
                }
                inner.put("elmImports", elmImports);
            }
        }
        return objs;
    }

    private ElmImport createImport(String name) {
        ElmImport elmImport = new ElmImport();
        boolean isData = !this.customPrimitives.contains(name);
        String modulePrefix = isData ? "Data." : "";
        elmImport.moduleName = modulePrefix + name;
        if (isData) {
            elmImport.as = name;
        }
        elmImport.exposures = new TreeSet<String>();
        elmImport.exposures.add(name);
        elmImport.hasExposures = true;
        return elmImport;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    private static boolean anyOperationParam(List<CodegenOperation> operations, Predicate<CodegenParameter> predicate) {
        return operations.stream().flatMap(operation -> Stream.of(operation.bodyParams.stream(), operation.queryParams.stream(), operation.pathParams.stream(), operation.headerParams.stream())).flatMap(a -> a).filter(predicate).findAny().isPresent();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        boolean hasUuid;
        boolean bl;
        ElmImport elmImport;
        Map objs = (Map)operations.get("operations");
        List ops = (List)objs.get("operation");
        HashMap dependencies = new HashMap();
        for (Object op : ops) {
            String string;
            if (ElmVersion.ELM_018.equals((Object)this.elmVersion)) {
                void var8_11;
                String string2 = ((CodegenOperation)op).path;
                for (CodegenParameter codegenParameter : ((CodegenOperation)op).pathParams) {
                    String var = this.paramToString("params", codegenParameter, false, null);
                    String string3 = var8_11.replace("{" + codegenParameter.paramName + "}", "\" ++ " + var + " ++ \"");
                }
                ((CodegenOperation)op).path = ("\"" + (String)var8_11 + "\"").replaceAll(" \\+\\+ \"\"", "");
            } else {
                List<String> list = Arrays.asList(((CodegenOperation)op).path.substring(1).split("/"));
                String path = list.stream().map(str -> str.startsWith("{") && str.endsWith("}") ? str : "\"" + str + "\"").collect(Collectors.joining(", "));
                for (CodegenParameter param3 : ((CodegenOperation)op).pathParams) {
                    String str2 = this.paramToString("params", param3, false, null);
                    path = path.replace("{" + param3.paramName + "}", str2);
                }
                ((CodegenOperation)op).path = path;
                String string4 = ((CodegenOperation)op).queryParams.stream().map(param -> this.paramToString("params", (CodegenParameter)param, true, "Url.string \"" + param.baseName + "\"")).collect(Collectors.joining(", "));
                ((CodegenOperation)op).vendorExtensions.put("query", string4);
                String headers = ((CodegenOperation)op).headerParams.stream().map(param -> this.paramToString("headers", (CodegenParameter)param, true, "Http.header \"" + param.baseName + "\"")).collect(Collectors.joining(", "));
                ((CodegenOperation)op).vendorExtensions.put("headers", headers);
            }
            if (!(((CodegenOperation)op).bodyParam == null || ((CodegenOperation)op).bodyParam.isPrimitiveType || ((CodegenOperation)op).bodyParam.isMapContainer || (string = (String)((CodegenOperation)op).bodyParam.vendorExtensions.get(ENCODER)) == null || dependencies.containsKey(((CodegenOperation)op).bodyParam.dataType))) {
                dependencies.put(((CodegenOperation)op).bodyParam.dataType, new TreeSet());
            }
            for (CodegenResponse resp : ((CodegenOperation)op).responses) {
                String string5;
                if (resp.primitiveType || resp.isMapContainer || (string5 = (String)resp.vendorExtensions.get(DECODER)) == null || dependencies.containsKey(resp.dataType)) continue;
                dependencies.put(resp.dataType, new TreeSet());
            }
        }
        ArrayList<ElmImport> elmImports = new ArrayList<ElmImport>();
        for (Map.Entry entry : dependencies.entrySet()) {
            elmImport = new ElmImport();
            String string = (String)entry.getKey();
            elmImport.moduleName = "Data." + string;
            elmImport.as = string;
            elmImport.exposures = (Set)entry.getValue();
            elmImport.exposures.add(string);
            elmImport.hasExposures = true;
            elmImports.add(elmImport);
        }
        boolean hasDate = ElmClientCodegen.anyOperationParam(ops, param -> param.isDate);
        if (hasDate) {
            ElmImport elmImport2 = new ElmImport();
            elmImport2.moduleName = "DateOnly";
            elmImport2.exposures = new TreeSet<String>();
            elmImport2.exposures.add("DateOnly");
            elmImport2.hasExposures = true;
            elmImports.add(elmImport2);
        }
        if (bl = ElmClientCodegen.anyOperationParam(ops, param -> param.isDateTime)) {
            elmImport = new ElmImport();
            elmImport.moduleName = "DateTime";
            elmImport.exposures = new TreeSet<String>();
            elmImport.exposures.add("DateTime");
            elmImport.hasExposures = true;
            elmImports.add(elmImport);
        }
        if (hasUuid = ElmClientCodegen.anyOperationParam(ops, param -> param.isUuid)) {
            ElmImport elmImport3 = new ElmImport();
            elmImport3.moduleName = "Uuid";
            elmImport3.exposures = new TreeSet<String>();
            elmImport3.exposures.add("Uuid");
            elmImport3.hasExposures = true;
            elmImports.add(elmImport3);
        }
        operations.put("elmImports", elmImports);
        return operations;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return this.toOptionalValue("\"" + p.getDefault().toString() + "\"");
            }
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return this.toOptionalValue(Boolean.valueOf(p.getDefault().toString()) != false ? "True" : "False");
            }
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isDateSchema(p)) {
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                return this.toOptionalValue(p.getDefault().toString());
            }
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return this.toOptionalValue(p.getDefault().toString());
            }
            return this.toOptionalValue(null);
        }
        return this.toOptionalValue(null);
    }

    private String toOptionalValue(String value) {
        if (value == null) {
            return "Nothing";
        }
        return "(Just " + value + ")";
    }

    private Optional<String> paramToStringMapper(String paramName, CodegenProperty property) {
        if (property.isEnum) {
            return Optional.of(this.toVarName(paramName) + "ToString");
        }
        if (property.isString || property.isBinary || property.isByteArray) {
            return Optional.empty();
        }
        if (property.isBoolean) {
            return Optional.of("(\\val -> if val then \"true\" else \"false\")");
        }
        if (property.isDateTime) {
            return Optional.of("DateTime.toString");
        }
        if (property.isDate) {
            return Optional.of("DateOnly.toString");
        }
        if (property.isUuid) {
            return Optional.of("Uuid.toString");
        }
        if (ElmVersion.ELM_018.equals((Object)this.elmVersion)) {
            return Optional.of("toString");
        }
        if (property.isInteger || property.isLong) {
            return Optional.of("String.fromInt");
        }
        if (property.isFloat || property.isDouble) {
            return Optional.of("String.fromFloat");
        }
        throw new RuntimeException("Parameter '" + paramName + "' cannot be converted to a string. Please report the issue.");
    }

    private CodegenProperty paramToProperty(CodegenParameter parameter) {
        CodegenProperty property = new CodegenProperty();
        property.isEnum = parameter.isEnum;
        property.isString = parameter.isString;
        property.isBinary = parameter.isBinary;
        property.isByteArray = parameter.isByteArray;
        property.isBoolean = parameter.isBoolean;
        property.isDateTime = parameter.isDateTime;
        property.isDate = parameter.isDate;
        property.isUuid = parameter.isUuid;
        property.isInteger = parameter.isInteger;
        property.isLong = parameter.isLong;
        property.isFloat = parameter.isFloat;
        property.isDouble = parameter.isDouble;
        return property;
    }

    private String paramToString(String prefix, CodegenParameter param, boolean useMaybe, String maybeMapResult) {
        String paramName = (ElmVersion.ELM_018.equals((Object)this.elmVersion) ? "" : prefix + ".") + param.paramName;
        if (!useMaybe) {
            param.required = true;
        }
        String mapFn = param.isListContainer ? "(String.join \",\"" + this.paramToStringMapper(param.paramName, param.items).map(mapper -> " << List.map " + mapper).orElse("") + ")" : this.paramToStringMapper(param.paramName, this.paramToProperty(param)).orElse("");
        String mapResult = "";
        if (maybeMapResult != null) {
            mapResult = "".equals(mapFn) ? maybeMapResult : maybeMapResult + (param.required ? " <|" : " <<");
        }
        String just = useMaybe ? "Just (" : "";
        String justEnd = useMaybe ? ")" : "";
        return (param.required ? just : "Maybe.map (") + mapResult + " " + mapFn + (param.required ? " " : ") ") + paramName + (param.required ? justEnd : "");
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty property = super.fromProperty(name, p);
        if (property.isEnum) {
            this.addEncoderAndDecoder(property.vendorExtensions, property.baseName, DataTypeExposure.INTERNAL);
            property.vendorExtensions.put(CUSTOM_TYPE, property.datatypeWithEnum);
        } else {
            boolean isPrimitiveType = property.isMapContainer ? this.isPrimitiveDataType(property.dataType) : property.isPrimitiveType;
            this.addEncoderAndDecoder(property.vendorExtensions, property.dataType, isPrimitiveType ? DataTypeExposure.PRIMITIVE : DataTypeExposure.EXTERNAL);
        }
        return property;
    }

    @Override
    public CodegenResponse fromResponse(String responseCode, ApiResponse resp) {
        CodegenResponse response = super.fromResponse(responseCode, resp);
        if (response.dataType != null) {
            boolean isPrimitiveType = response.isMapContainer ? this.isPrimitiveDataType(response.dataType) : response.primitiveType;
            this.addEncoderAndDecoder(response.vendorExtensions, response.dataType, isPrimitiveType ? DataTypeExposure.PRIMITIVE : DataTypeExposure.EXTERNAL);
        }
        return response;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        boolean isPrimitiveType = parameter.isMapContainer ? this.isPrimitiveDataType(parameter.dataType) : parameter.isPrimitiveType;
        this.addEncoderAndDecoder(parameter.vendorExtensions, parameter.dataType, isPrimitiveType ? DataTypeExposure.PRIMITIVE : DataTypeExposure.EXTERNAL);
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty property) {
        super.updateCodegenPropertyEnum(property);
        if (!this.elmPrefixCustomTypeVariants.booleanValue()) {
            return;
        }
        Map<String, Object> allowableValues = property.allowableValues;
        if (allowableValues == null) {
            return;
        }
        ArrayList enumVars = (ArrayList)allowableValues.get("enumVars");
        if (enumVars == null) {
            return;
        }
        String prefix = this.toEnumName(property);
        for (Map enumVar : enumVars) {
            if (enumVar.containsKey("_isPrefixed")) continue;
            enumVar.put("name", prefix + enumVar.get("name"));
            enumVar.put("_isPrefixed", true);
        }
    }

    private boolean isPrimitiveDataType(String dataType) {
        return this.languageSpecificPrimitives.contains(dataType);
    }

    private void addEncoderAndDecoder(Map<String, Object> vendorExtensions, String dataType, DataTypeExposure dataTypeExposure) {
        String encodeName;
        String decoderName;
        String baseName = StringUtils.camelize(dataType, true);
        switch (dataTypeExposure) {
            case EXPOSED: {
                decoderName = "decoder";
                encodeName = "encode";
                break;
            }
            case INTERNAL: {
                encodeName = "encode" + org.apache.commons.lang3.StringUtils.capitalize((String)baseName);
                decoderName = baseName + "Decoder";
                break;
            }
            case EXTERNAL: {
                encodeName = dataType + ".encode";
                decoderName = dataType + ".decoder";
                break;
            }
            case PRIMITIVE: {
                encodeName = "Encode." + baseName;
                decoderName = "Decode." + baseName;
                break;
            }
            default: {
                encodeName = "";
                decoderName = "";
            }
        }
        if (!vendorExtensions.containsKey(ENCODER)) {
            vendorExtensions.put(ENCODER, encodeName);
        }
        if (!vendorExtensions.containsKey(DECODER)) {
            vendorExtensions.put(DECODER, decoderName);
        }
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String elmPostProcessFile = System.getenv("ELM_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)elmPostProcessFile)) {
            return;
        }
        if ("elm".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = elmPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }

    private static enum ElmVersion {
        ELM_018,
        ELM_019;

    }

    private static class ElmImport {
        public String moduleName;
        public String as;
        public Set<String> exposures;
        public Boolean hasExposures;

        private ElmImport() {
        }
    }

    private static enum DataTypeExposure {
        EXPOSED,
        INTERNAL,
        EXTERNAL,
        PRIMITIVE;

    }
}

