/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.produce;

import java.util.HashSet;
import java.util.List;
import org.apache.servicecomb.common.rest.codec.produce.ProduceJsonProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceTextPlainProcessor;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;

public final class ProduceProcessorManager
extends RegisterManager<String, ProduceProcessor> {
    private static final List<ProduceProcessor> produceProcessor = SPIServiceUtils.getSortedService(ProduceProcessor.class);
    private static final String NAME = "produce processor mgr";
    public static final String DEFAULT_TYPE = "application/json";
    public static final ProduceProcessorManager INSTANCE = new ProduceProcessorManager();
    public static final ProduceProcessor JSON_PROCESSOR = (ProduceProcessor)SPIServiceUtils.getTargetService(ProduceProcessor.class, ProduceJsonProcessor.class);
    public static final ProduceProcessor PLAIN_PROCESSOR = (ProduceProcessor)SPIServiceUtils.getTargetService(ProduceProcessor.class, ProduceTextPlainProcessor.class);
    public static final ProduceProcessor DEFAULT_PROCESSOR = JSON_PROCESSOR;

    private ProduceProcessorManager() {
        super(NAME);
        HashSet set = new HashSet();
        produceProcessor.forEach(processor -> {
            if (set.add(processor.getName())) {
                this.register(processor.getName(), processor);
            }
        });
    }
}

