/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public final class OperatorTake<T>
implements Observable.Operator<T, T> {
    final int limit;

    public OperatorTake(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit >= 0 required but it was " + limit);
        }
        this.limit = limit;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber parent = new Subscriber<T>(){
            int count;
            boolean completed;

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    this.completed = true;
                    child.onCompleted();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                if (!this.completed) {
                    this.completed = true;
                    try {
                        child.onError(e);
                    }
                    finally {
                        this.unsubscribe();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T i) {
                if (!this.isUnsubscribed() && this.count++ < OperatorTake.this.limit) {
                    boolean stop = this.count == OperatorTake.this.limit;
                    child.onNext(i);
                    if (stop && !this.completed) {
                        this.completed = true;
                        try {
                            child.onCompleted();
                        }
                        finally {
                            this.unsubscribe();
                        }
                    }
                }
            }

            @Override
            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){
                    final AtomicLong requested = new AtomicLong(0L);

                    @Override
                    public void request(long n) {
                        if (n > 0L && !completed) {
                            long r;
                            long c;
                            while ((c = Math.min(n, (long)OperatorTake.this.limit - (r = this.requested.get()))) != 0L) {
                                if (!this.requested.compareAndSet(r, r + c)) continue;
                                producer.request(c);
                                break;
                            }
                        }
                    }
                });
            }
        };
        if (this.limit == 0) {
            child.onCompleted();
            parent.unsubscribe();
        }
        child.add(parent);
        return parent;
    }
}

