/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os.cpu;

import com.netflix.spectator.api.Id;

public abstract class AbstractCpuUsage {
    protected Id id;
    protected double usage;
    protected int cpuCount = Runtime.getRuntime().availableProcessors();

    public AbstractCpuUsage(Id id) {
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }

    public double getUsage() {
        return this.usage;
    }

    public void setUsage(double usage) {
        this.usage = usage;
    }

    protected void updateUsage(double periodBusy, double periodTotal, boolean irixMode) {
        double d = this.usage = periodTotal == 0.0 ? 0.0 : periodBusy / periodTotal;
        if (this.usage > 1.0) {
            this.usage = 1.0;
        }
        if (irixMode) {
            this.usage *= (double)this.cpuCount;
        }
    }

    static class Period {
        double last;
        double period;

        Period() {
        }

        void update(double current) {
            this.period = current - this.last;
            this.last = current;
        }
    }
}

