/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.Layout;

public class LayoutRegularSegmented
implements Layout {
    private long total;
    private long done;
    private long innerNelems;
    private long startPos;
    private long recSize;
    private int elemSize;
    private IndexChunker chunker;
    private IndexChunker.Chunk chunkOuter;
    private IndexChunker.Chunk chunkInner = new IndexChunker.Chunk(0L, 0, 0L);
    private static final boolean debugNext = false;
    private int needInner;
    private int doneInner;

    public LayoutRegularSegmented(long startPos, int elemSize, long recSize, int[] srcShape, Section wantSection) throws InvalidRangeException {
        assert (startPos > 0L);
        assert (elemSize > 0);
        assert (recSize > 0L);
        assert (srcShape.length > 0);
        this.startPos = startPos;
        this.elemSize = elemSize;
        this.recSize = recSize;
        this.chunker = new IndexChunker(srcShape, wantSection);
        this.total = this.chunker.getTotalNelems();
        this.innerNelems = srcShape[0] == 0 ? 0L : Index.computeSize(srcShape) / (long)srcShape[0];
        this.done = 0L;
    }

    @Override
    public long getTotalNelems() {
        return this.total;
    }

    @Override
    public int getElemSize() {
        return this.elemSize;
    }

    @Override
    public boolean hasNext() {
        return this.done < this.total;
    }

    private long getFilePos(long elem) {
        long segno = elem / this.innerNelems;
        long offset = elem % this.innerNelems;
        return this.startPos + segno * this.recSize + offset * (long)this.elemSize;
    }

    private int getMaxElem(long startElem) {
        return (int)(this.innerNelems - startElem % this.innerNelems);
    }

    @Override
    public Layout.Chunk next() {
        IndexChunker.Chunk result;
        if (this.needInner > 0) {
            result = this.nextInner(false, 0);
        } else {
            result = this.nextOuter();
            int nelems = this.getMaxElem(result.getSrcElem());
            if (nelems < result.getNelems()) {
                result = this.nextInner(true, nelems);
            }
        }
        this.done += (long)result.getNelems();
        this.doneInner += result.getNelems();
        this.needInner -= result.getNelems();
        return result;
    }

    private IndexChunker.Chunk nextInner(boolean first, int nelems) {
        if (first) {
            this.chunkInner.setNelems(nelems);
            this.chunkInner.setDestElem(this.chunkOuter.getDestElem());
            this.needInner = this.chunkOuter.getNelems();
            this.doneInner = 0;
        } else {
            this.chunkInner.incrDestElem(this.chunkInner.getNelems());
            nelems = this.getMaxElem(this.chunkOuter.getSrcElem() + (long)this.doneInner);
            nelems = Math.min(nelems, this.needInner);
            this.chunkInner.setNelems(nelems);
        }
        this.chunkInner.setSrcElem(this.chunkOuter.getSrcElem() + (long)this.doneInner);
        this.chunkInner.setSrcPos(this.getFilePos(this.chunkOuter.getSrcElem() + (long)this.doneInner));
        return this.chunkInner;
    }

    public IndexChunker.Chunk nextOuter() {
        this.chunkOuter = this.chunker.next();
        this.chunkOuter.setSrcPos(this.getFilePos(this.chunkOuter.getSrcElem()));
        return this.chunkOuter;
    }
}

