/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.ncml.NcmlReader;
import ucar.nc2.util.CancelTask;

public class GIEFConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "GIEF";

    GIEFConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        NcmlReader.wrapNcmlResource(this.datasetBuilder, "resources/nj22/coords/GIEF.ncml", cancelTask);
        Dimension timeDim = this.rootGroup.findDimension("time").orElse(null);
        VariableDS.Builder base_time = this.rootGroup.findVariableLocal("base_time").orElse(null);
        VariableDS.Builder time_offset = this.rootGroup.findVariableLocal("time_offset").orElse(null);
        Variable.Builder<?> timeVar = this.rootGroup.findVariableLocal("time").orElseThrow(() -> new IllegalStateException("must have time variable"));
        String time_units = this.rootGroup.getAttributeContainer().findAttributeString("time_units", null);
        timeVar.addAttribute(new Attribute("units", time_units));
        Variable.Builder<?> levelVar = this.rootGroup.findVariableLocal("level").orElseThrow(() -> new IllegalStateException("must have level variable"));
        String level_units = this.rootGroup.getAttributeContainer().findAttributeString("level_units", null);
        String level_name = this.rootGroup.getAttributeContainer().findAttributeString("level_name", null);
        levelVar.addAttribute(new Attribute("units", level_units));
        levelVar.addAttribute(new Attribute("long_name", level_name));
        String unit_name = this.rootGroup.getAttributeContainer().findAttributeString("unit_name", null);
        String parameter_name = this.rootGroup.getAttributeContainer().findAttributeString("parameter_name", null);
        for (Variable.Builder<?> v : this.rootGroup.vbuilders) {
            if (v.getRank() <= 1) continue;
            v.addAttribute(new Attribute("units", unit_name));
            v.addAttribute(new Attribute("long_name", v.shortName + " " + parameter_name));
            v.addAttribute(new Attribute("_CoordinateAxes", "time level latitude longitude"));
        }
        Attribute translation = this.rootGroup.getAttributeContainer().findAttributeIgnoreCase("translation");
        Attribute affine = this.rootGroup.getAttributeContainer().findAttributeIgnoreCase("affine_transformation");
        double startLat = translation.getNumericValue(1).doubleValue();
        double incrLat = affine.getNumericValue(6).doubleValue();
        Variable.Builder<?> latVar = this.rootGroup.findVariableLocal("latitude").orElseThrow(() -> new IllegalStateException("must have latitude variable"));
        latVar.setAutoGen(startLat, incrLat);
        double startLon = translation.getNumericValue(0).doubleValue();
        double incrLon = affine.getNumericValue(3).doubleValue();
        Variable.Builder<?> lonVar = this.rootGroup.findVariableLocal("longitude").orElseThrow(() -> new IllegalStateException("must have longitude variable"));
        lonVar.setAutoGen(startLon, incrLon);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return GIEFConvention.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new GIEFConvention(datasetBuilder);
        }
    }
}

