/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geometrySerde;

import java.lang.reflect.Field;
import org.apache.sedona.common.geometrySerde.CoordinateType;
import org.apache.sedona.common.geometrySerde.GeometryBuffer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import sun.misc.Unsafe;

class UnsafeGeometryBuffer
implements GeometryBuffer {
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private CoordinateType coordinateType = CoordinateType.XY;
    private final byte[] bytes;
    private final long baseOffset;
    private int markOffset = 0;

    public static boolean isUnsafeAvailable() {
        return UNSAFE != null;
    }

    public UnsafeGeometryBuffer(int bufferSize) {
        this.bytes = new byte[bufferSize];
        this.baseOffset = BYTE_ARRAY_BASE_OFFSET;
    }

    public UnsafeGeometryBuffer(byte[] bytes, int offset) {
        this.bytes = bytes;
        this.baseOffset = (long)offset + BYTE_ARRAY_BASE_OFFSET;
    }

    public UnsafeGeometryBuffer(byte[] bytes) {
        this.bytes = bytes;
        this.baseOffset = BYTE_ARRAY_BASE_OFFSET;
    }

    @Override
    public CoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    @Override
    public void setCoordinateType(CoordinateType coordinateType) {
        this.coordinateType = coordinateType;
    }

    @Override
    public int getLength() {
        return (int)((long)this.bytes.length - this.baseOffset + BYTE_ARRAY_BASE_OFFSET);
    }

    @Override
    public void mark(int offset) {
        this.markOffset = offset;
    }

    @Override
    public int getMark() {
        return this.markOffset;
    }

    @Override
    public void putByte(int offset, byte value) {
        UNSAFE.putByte(this.bytes, this.baseOffset + (long)offset, value);
    }

    @Override
    public byte getByte(int offset) {
        assert (this.baseOffset + (long)offset < (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        return UNSAFE.getByte(this.bytes, this.baseOffset + (long)offset);
    }

    @Override
    public void putBytes(int offset, byte[] inBytes) {
        assert (this.baseOffset + (long)offset + (long)inBytes.length <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        UNSAFE.copyMemory(inBytes, BYTE_ARRAY_BASE_OFFSET, this.bytes, this.baseOffset + (long)offset, inBytes.length);
    }

    @Override
    public void getBytes(byte[] outBytes, int offset, int length) {
        assert (this.baseOffset + (long)offset + (long)length <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        UNSAFE.copyMemory(this.bytes, this.baseOffset + (long)offset, outBytes, BYTE_ARRAY_BASE_OFFSET, length);
    }

    @Override
    public void putInt(int offset, int value) {
        assert (this.baseOffset + (long)offset + 4L <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        UNSAFE.putInt(this.bytes, this.baseOffset + (long)offset, value);
    }

    @Override
    public int getInt(int offset) {
        assert (this.baseOffset + (long)offset + 4L <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        return UNSAFE.getInt(this.bytes, this.baseOffset + (long)offset);
    }

    @Override
    public void putCoordinate(int offset, Coordinate coordinate) {
        long coordOffset = this.baseOffset + (long)offset;
        assert (coordOffset + (long)this.coordinateType.bytes <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        switch (this.coordinateType) {
            case XY: {
                UNSAFE.putDouble(this.bytes, coordOffset, coordinate.x);
                UNSAFE.putDouble(this.bytes, coordOffset + 8L, coordinate.y);
                break;
            }
            case XYZ: {
                UNSAFE.putDouble(this.bytes, coordOffset, coordinate.x);
                UNSAFE.putDouble(this.bytes, coordOffset + 8L, coordinate.y);
                UNSAFE.putDouble(this.bytes, coordOffset + 16L, coordinate.getZ());
                break;
            }
            case XYM: {
                UNSAFE.putDouble(this.bytes, coordOffset, coordinate.x);
                UNSAFE.putDouble(this.bytes, coordOffset + 8L, coordinate.y);
                UNSAFE.putDouble(this.bytes, coordOffset + 16L, coordinate.getM());
                break;
            }
            case XYZM: {
                UNSAFE.putDouble(this.bytes, coordOffset, coordinate.x);
                UNSAFE.putDouble(this.bytes, coordOffset + 8L, coordinate.y);
                UNSAFE.putDouble(this.bytes, coordOffset + 16L, coordinate.getZ());
                UNSAFE.putDouble(this.bytes, coordOffset + 24L, coordinate.getM());
                break;
            }
            default: {
                throw new IllegalStateException("coordinateType was not configured properly");
            }
        }
    }

    @Override
    public CoordinateSequence getCoordinate(int offset) {
        long coordOffset = this.baseOffset + (long)offset;
        assert (coordOffset + (long)this.coordinateType.bytes <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        double x = UNSAFE.getDouble(this.bytes, coordOffset);
        double y = UNSAFE.getDouble(this.bytes, coordOffset + 8L);
        Coordinate[] coordinates = new Coordinate[1];
        switch (this.coordinateType) {
            case XY: {
                coordinates[0] = new CoordinateXY(x, y);
                return new CoordinateArraySequence(coordinates, 2, 0);
            }
            case XYZ: {
                double z = UNSAFE.getDouble(this.bytes, coordOffset + 16L);
                coordinates[0] = new Coordinate(x, y, z);
                return new CoordinateArraySequence(coordinates, 3, 0);
            }
            case XYM: {
                double m3 = UNSAFE.getDouble(this.bytes, coordOffset + 16L);
                coordinates[0] = new CoordinateXYM(x, y, m3);
                return new CoordinateArraySequence(coordinates, 3, 1);
            }
            case XYZM: {
                double z = UNSAFE.getDouble(this.bytes, coordOffset + 16L);
                double m4 = UNSAFE.getDouble(this.bytes, coordOffset + 24L);
                coordinates[0] = new CoordinateXYZM(x, y, z, m4);
                return new CoordinateArraySequence(coordinates, 4, 1);
            }
        }
        throw new IllegalStateException("coordinateType was not configured properly");
    }

    @Override
    public void putCoordinates(int offset, CoordinateSequence coordinates) {
        long coordOffset = this.baseOffset + (long)offset;
        int numCoordinates = coordinates.size();
        assert (coordOffset + (long)this.coordinateType.bytes * (long)numCoordinates <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        switch (this.coordinateType) {
            case XY: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    UNSAFE.putDouble(this.bytes, coordOffset, coord.x);
                    UNSAFE.putDouble(this.bytes, coordOffset + 8L, coord.y);
                    coordOffset += 16L;
                }
                break;
            }
            case XYZ: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    UNSAFE.putDouble(this.bytes, coordOffset, coord.x);
                    UNSAFE.putDouble(this.bytes, coordOffset + 8L, coord.y);
                    UNSAFE.putDouble(this.bytes, coordOffset + 16L, coord.getZ());
                    coordOffset += 24L;
                }
                break;
            }
            case XYM: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    UNSAFE.putDouble(this.bytes, coordOffset, coord.x);
                    UNSAFE.putDouble(this.bytes, coordOffset + 8L, coord.y);
                    UNSAFE.putDouble(this.bytes, coordOffset + 16L, coord.getM());
                    coordOffset += 24L;
                }
                break;
            }
            case XYZM: {
                for (int k = 0; k < numCoordinates; ++k) {
                    Coordinate coord = coordinates.getCoordinate(k);
                    UNSAFE.putDouble(this.bytes, coordOffset, coord.x);
                    UNSAFE.putDouble(this.bytes, coordOffset + 8L, coord.y);
                    UNSAFE.putDouble(this.bytes, coordOffset + 16L, coord.getZ());
                    UNSAFE.putDouble(this.bytes, coordOffset + 24L, coord.getM());
                    coordOffset += 32L;
                }
                break;
            }
            default: {
                throw new IllegalStateException("coordinateType was not configured properly");
            }
        }
    }

    @Override
    public CoordinateSequence getCoordinates(int offset, int numCoordinates) {
        long coordOffset = this.baseOffset + (long)offset;
        assert (coordOffset + (long)this.coordinateType.bytes * (long)numCoordinates <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        Coordinate[] coordinates = new Coordinate[numCoordinates];
        int dimension = 2;
        int measures = 0;
        switch (this.coordinateType) {
            case XY: {
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = UNSAFE.getDouble(this.bytes, coordOffset);
                    double y = UNSAFE.getDouble(this.bytes, coordOffset + 8L);
                    coordinates[k] = new CoordinateXY(x, y);
                    coordOffset += 16L;
                }
                break;
            }
            case XYZ: {
                dimension = 3;
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = UNSAFE.getDouble(this.bytes, coordOffset);
                    double y = UNSAFE.getDouble(this.bytes, coordOffset + 8L);
                    double z = UNSAFE.getDouble(this.bytes, coordOffset + 16L);
                    coordinates[k] = new Coordinate(x, y, z);
                    coordOffset += 24L;
                }
                break;
            }
            case XYM: {
                dimension = 3;
                measures = 1;
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = UNSAFE.getDouble(this.bytes, coordOffset);
                    double y = UNSAFE.getDouble(this.bytes, coordOffset + 8L);
                    double m3 = UNSAFE.getDouble(this.bytes, coordOffset + 16L);
                    coordinates[k] = new CoordinateXYM(x, y, m3);
                    coordOffset += 24L;
                }
                break;
            }
            case XYZM: {
                dimension = 4;
                measures = 1;
                for (int k = 0; k < numCoordinates; ++k) {
                    double x = UNSAFE.getDouble(this.bytes, coordOffset);
                    double y = UNSAFE.getDouble(this.bytes, coordOffset + 8L);
                    double z = UNSAFE.getDouble(this.bytes, coordOffset + 16L);
                    double m4 = UNSAFE.getDouble(this.bytes, coordOffset + 24L);
                    coordinates[k] = new CoordinateXYZM(x, y, z, m4);
                    coordOffset += 32L;
                }
                break;
            }
            default: {
                throw new IllegalStateException("coordinateType was not configured properly");
            }
        }
        return new CoordinateArraySequence(coordinates, dimension, measures);
    }

    @Override
    public GeometryBuffer slice(int offset) {
        assert (this.baseOffset + (long)offset <= (long)this.bytes.length + BYTE_ARRAY_BASE_OFFSET);
        int bytesOffset = (int)(this.baseOffset + (long)offset - BYTE_ARRAY_BASE_OFFSET);
        return new UnsafeGeometryBuffer(this.bytes, bytesOffset);
    }

    @Override
    public byte[] toByteArray() {
        if (this.baseOffset == BYTE_ARRAY_BASE_OFFSET) {
            return this.bytes;
        }
        int length = (int)((long)this.bytes.length - this.baseOffset + BYTE_ARRAY_BASE_OFFSET);
        byte[] copy = new byte[length];
        UNSAFE.copyMemory(this.bytes, this.baseOffset, copy, BYTE_ARRAY_BASE_OFFSET, length);
        return copy;
    }

    static {
        Unsafe unsafe;
        long byteArrayOffset = 0L;
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
            byteArrayOffset = unsafe.arrayBaseOffset(byte[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            unsafe = null;
        }
        UNSAFE = unsafe;
        BYTE_ARRAY_BASE_OFFSET = byteArrayOffset;
    }
}

