/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u000b\u0017\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%\u0011\tC\u0003F\u0001\u0011\u0005a\tC\u0004M\u0001\t\u0007I\u0011B'\t\rE\u0003\u0001\u0015!\u0003O\u0011\u0015)\u0005\u0001\"\u0001S\u0011\u0015)\u0005\u0001\"\u0001]\u0011\u00151\u0007\u0001\"\u0001h\u0011\u00151\u0007\u0001\"\u0003x\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!!\u0006\u0001\t\u0013\t9\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u001dI\u0011Q\u0007\f\u0002\u0002#\u0005\u0011q\u0007\u0004\t+Y\t\t\u0011#\u0001\u0002:!1Q)\u0005C\u0001\u0003wA\u0011\"!\u0010\u0012#\u0003%\t!a\u0010\t\u0013\u0005U\u0013#%A\u0005\u0002\u0005}\"\u0001I$f_B\u000b'/];fiR{7\u000b]1sWN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJT!a\u0006\r\u0002\u000fA\f'/];fi*\u0011\u0011DG\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u001c9\u0005IQ\r_3dkRLwN\u001c\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017\u0001E6fsZ\u000bG.^3NKR\fG)\u0019;b!\u0011q3'N\u001b\u000e\u0003=R!\u0001M\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tFA\u0002NCB\u0004\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d)\u001b\u0005I$B\u0001\u001e%\u0003\u0019a$o\\8u}%\u0011A\bK\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=Q\u0005!\u0012m]:v[\u0016\u0014\u0015N\\1ss&\u001b8\u000b\u001e:j]\u001e\u0004\"a\n\"\n\u0005\rC#a\u0002\"p_2,\u0017M\\\u0001\u0017CN\u001cX/\\3J]RLd'S:US6,7\u000f^1na\u00061A(\u001b8jiz\"BaR%K\u0017B\u0011\u0001\nA\u0007\u0002-!)A\u0006\u0002a\u0001[!9\u0001\t\u0002I\u0001\u0002\u0004\t\u0005b\u0002#\u0005!\u0003\u0005\r!Q\u0001\u0013O\u0016|\u0007+\u0019:rk\u0016$X*\u001a;b\t\u0006$\u0018-F\u0001O!\tAu*\u0003\u0002Q-\t\u0011r)Z8QCJ\fX/\u001a;NKR\fG)\u0019;b\u0003M9Wm\u001c)beF,X\r^'fi\u0006$\u0015\r^1!)\r95\u000b\u0016\u0005\u0006Y\u001d\u0001\r!\f\u0005\u0006+\u001e\u0001\rAV\u0001\u0005G>tg\r\u0005\u0002X56\t\u0001L\u0003\u0002Z9\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\\1\n91+\u0015'D_:4GcA$^=\")A\u0006\u0003a\u0001[!)Q\u000b\u0003a\u0001?B\u0011\u0001\rZ\u0007\u0002C*\u0011QK\u0019\u0006\u0003G\u0002\na\u0001[1e_>\u0004\u0018BA3b\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u000691m\u001c8wKJ$HC\u00015o!\tIG.D\u0001k\u0015\tYG$A\u0003usB,7/\u0003\u0002nU\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b=L\u0001\u0019\u00019\u0002\u001bA\f'/];fiN\u001b\u0007.Z7b!\t\tX/D\u0001s\u0015\t\u0019H/\u0001\u0004tG\",W.\u0019\u0006\u0003/\u0001J!A\u001e:\u0003\u00175+7o]1hKRK\b/\u001a\u000b\u0003QbDQa\u001c\u0006A\u0002e\u0004\"!\u001d>\n\u0005m\u0014(!C$s_V\u0004H+\u001f9f\u0003M\u0019wN\u001c<feR4\u0015.\u001a7e/&$\bnR3p)\rq\u00181\u0001\t\u0003S~L1!!\u0001k\u0005!!\u0015\r^1UsB,\u0007bBA\u0003\u0017\u0001\u0007\u0011qA\u0001\fa\u0006\u0014\u0018/^3u)f\u0004X\rE\u0002r\u0003\u0013I1!a\u0003s\u0005\u0011!\u0016\u0010]3\u0002\u001f%\u001cx)Z8nKR\u0014\u0018PR5fY\u0012$2!QA\t\u0011\u0019\t\u0019\u0002\u0004a\u0001k\u0005Ia-[3mI:\u000bW.Z\u0001\u0016G>tg/\u001a:u!JLW.\u001b;jm\u00164\u0015.\u001a7e)\rq\u0018\u0011\u0004\u0005\b\u00037i\u0001\u0019AA\u000f\u0003\u00151\u0017.\u001a7e!\r\t\u0018qD\u0005\u0004\u0003C\u0011(!\u0004)sS6LG/\u001b<f)f\u0004X-A\td_:4XM\u001d;He>,\bOR5fY\u0012$2A`A\u0014\u0011\u0019\tYB\u0004a\u0001s\u0006!\u0012n]#mK6,g\u000e\u001e+za\u0016<\u0016\u000e\u001e5HK>$R!QA\u0017\u0003cAq!a\f\u0010\u0001\u0004\t9!\u0001\u0007sKB,\u0017\r^3e)f\u0004X\r\u0003\u0004\u00024=\u0001\r!N\u0001\u000ba\u0006\u0014XM\u001c;OC6,\u0017\u0001I$f_B\u000b'/];fiR{7\u000b]1sWN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJ\u0004\"\u0001S\t\u0014\u0005E1CCAA\u001c\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\t\u0016\u0004\u0003\u0006\r3FAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0003&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0015\u0002J\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class GeoParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final GeoParquetMetaData geoParquetMetaData;

    public static boolean $lessinit$greater$default$3() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    private GeoParquetMetaData geoParquetMetaData() {
        return this.geoParquetMetaData;
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable)field -> {
            StructField structField;
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertFieldWithGeo((Type)field), true, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REQUIRED.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertFieldWithGeo((Type)field), false, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertFieldWithGeo((Type)field), false);
                structField = new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)repetition);
            }
            return structField;
        });
        return StructType$.MODULE$.apply(fields.toSeq());
    }

    public DataType convertFieldWithGeo(Type parquetType) {
        DataType dataType;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            dataType = this.convertPrimitiveField(primitiveType);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            dataType = this.convertGroupField(groupType.asGroupType());
        } else {
            throw new MatchError((Object)type);
        }
        return dataType;
    }

    private boolean isGeometryField(String fieldName) {
        return this.geoParquetMetaData().columns().contains((Object)fieldName);
    }

    /*
     * Unable to fully structure code
     */
    private DataType convertPrimitiveField(PrimitiveType field) {
        block38: {
            block44: {
                block46: {
                    block45: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block37: {
                                                typeName = field.getPrimitiveTypeName();
                                                originalType = field.getOriginalType();
                                                var12_4 = typeName;
                                                if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var12_4)) break block37;
                                                var2_5 = BooleanType$.MODULE$;
                                                break block38;
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var12_4)) break block39;
                                            var2_5 = FloatType$.MODULE$;
                                            break block38;
                                        }
                                        if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var12_4)) break block40;
                                        var2_5 = DoubleType$.MODULE$;
                                        break block38;
                                    }
                                    if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var12_4)) break block41;
                                    var13_6 = originalType;
                                    if (OriginalType.INT_8.equals(var13_6)) {
                                        var8_7 = ByteType$.MODULE$;
                                    } else if (OriginalType.INT_16.equals(var13_6)) {
                                        var8_7 = ShortType$.MODULE$;
                                    } else {
                                        var9_8 = OriginalType.INT_32.equals(var13_6) != false ? true : var13_6 == null;
                                        if (var9_8) {
                                            var8_7 = IntegerType$.MODULE$;
                                        } else if (OriginalType.DATE.equals(var13_6)) {
                                            var8_7 = DateType$.MODULE$;
                                        } else if (OriginalType.DECIMAL.equals(var13_6)) {
                                            var8_7 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
                                        } else {
                                            if (OriginalType.UINT_8.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_16.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_32.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.TIME_MILLIS.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                                            }
                                            throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                        }
                                    }
                                    var2_5 = var8_7;
                                    break block38;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var12_4)) break block42;
                                var14_9 = originalType;
                                var7_10 = OriginalType.INT_64.equals(var14_9) != false ? true : var14_9 == null;
                                if (var7_10) {
                                    var6_11 = LongType$.MODULE$;
                                } else if (OriginalType.DECIMAL.equals(var14_9)) {
                                    var6_11 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
                                } else {
                                    if (OriginalType.UINT_64.equals(var14_9)) {
                                        throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                    }
                                    if (OriginalType.TIMESTAMP_MICROS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else if (OriginalType.TIMESTAMP_MILLIS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else {
                                        throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                    }
                                }
                                var2_5 = var6_11;
                                break block38;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var12_4)) break block43;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$2(org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter ), ()Z)((GeoParquetToSparkSchemaConverter)this), new StringBuilder(61).append("INT96 is not supported unless it's interpreted as timestamp. ").append(new StringBuilder(27).append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString()).toString());
                            var2_5 = TimestampType$.MODULE$;
                            break block38;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var12_4)) break block44;
                        var15_12 = false;
                        var16_13 = null;
                        var17_14 = originalType;
                        var5_15 = OriginalType.UTF8.equals(var17_14) != false ? true : (OriginalType.ENUM.equals(var17_14) != false ? true : OriginalType.JSON.equals(var17_14) != false);
                        if (!var5_15) break block45;
                        var4_16 = StringType$.MODULE$;
                        break block46;
                    }
                    if (var17_14 != null) ** GOTO lbl-1000
                    var15_12 = true;
                    var16_13 = var17_14;
                    if (this.isGeometryField(field.getName())) {
                        var4_16 = GeometryUDT$.MODULE$;
                    } else if (var15_12 && this.assumeBinaryIsString) {
                        var4_16 = StringType$.MODULE$;
                    } else if (var15_12) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.BSON.equals(var17_14)) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.DECIMAL.equals(var17_14)) {
                        var4_16 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(GeoParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
                    } else {
                        throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                    }
                }
                var2_5 = var4_16;
                break block38;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var12_4)) {
                var18_17 = originalType;
                if (!OriginalType.DECIMAL.equals(var18_17)) {
                    if (OriginalType.INTERVAL.equals(var18_17)) {
                        throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                    }
                    throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                }
                var3_18 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
                var2_5 = var3_18;
            } else {
                throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
            }
        }
        return var2_5;
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getOriginalType()).fold((Function0 & Serializable)() -> this.convert(field), (Function1 & Serializable)x0$1 -> {
            ArrayType arrayType;
            OriginalType originalType = x0$1;
            if (OriginalType.LIST.equals(originalType)) {
                ArrayType arrayType2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementTypeWithGeo(repeatedType, field.getName())) {
                    arrayType2 = new ArrayType(this.convertFieldWithGeo(repeatedType), false);
                } else {
                    Type elementType = repeatedType.asGroupType().getType(0);
                    boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType2 = new ArrayType(this.convertFieldWithGeo(elementType), optional);
                }
                arrayType = arrayType2;
            } else {
                boolean bl = OriginalType.MAP.equals(originalType) ? true : OriginalType.MAP_KEY_VALUE.equals(originalType);
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    GroupType keyValueType = field.getType(0).asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    Type keyType = keyValueType.getType(0);
                    Type valueType = keyValueType.getType(1);
                    boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType = new MapType(this.convertFieldWithGeo(keyType), this.convertFieldWithGeo(valueType), valueOptional);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString());
                }
            }
            return arrayType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementTypeWithGeo(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return originalType$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(originalType$1).append(")").toString();
    }

    private static final Nothing$ typeNotSupported$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(28).append("Parquet type not supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final Nothing$ typeNotImplemented$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(32).append("Parquet type not yet supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final Nothing$ illegalType$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(22).append("Illegal Parquet type: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        int precision = field$1.getDecimalMetadata().getPrecision();
        int scale = field$1.getDecimalMetadata().getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$2(GeoParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.geoParquetMetaData = (GeoParquetMetaData)GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(keyValueMetaData).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("GeoParquet file does not contain valid geo metadata");
        });
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, SQLConf conf) {
        this(keyValueMetaData, conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp());
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, Configuration conf) {
        this(keyValueMetaData, StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))));
    }
}

