/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sedona.common.utils.HalfOpenRectangle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.UnaryUnionOp;

public class GeomUtils {
    public static String printGeom(Geometry geom) {
        if (geom.getUserData() != null) {
            return geom.toText() + "\t" + geom.getUserData();
        }
        return geom.toText();
    }

    public static String printGeom(Object geom) {
        Geometry g = (Geometry)geom;
        return GeomUtils.printGeom(g);
    }

    public static int hashCode(Geometry geom) {
        return geom.getUserData() == null ? geom.hashCode() : geom.hashCode() * 31 + geom.getUserData().hashCode();
    }

    public static boolean equalsTopoGeom(Geometry geom1, Geometry geom2) {
        if (Objects.equals(geom1.getUserData(), geom2.getUserData())) {
            return geom1.equals(geom2);
        }
        return false;
    }

    public static boolean equalsExactGeom(Geometry geom1, Object geom2) {
        if (!(geom2 instanceof Geometry)) {
            return false;
        }
        Geometry g = (Geometry)geom2;
        if (Objects.equals(geom1.getUserData(), g.getUserData())) {
            return geom1.equalsExact(g);
        }
        return false;
    }

    public static boolean equalsExactGeomUnsortedUserData(Geometry geom1, Object geom2) {
        if (!(geom2 instanceof Geometry)) {
            return false;
        }
        Geometry g = (Geometry)geom2;
        if (GeomUtils.equalsUserData(geom1.getUserData(), g.getUserData())) {
            return geom1.equalsExact(g);
        }
        return false;
    }

    public static boolean equalsUserData(Object userData1, Object userData2) {
        Object[] split1 = ((String)userData1).split("\t");
        Object[] split2 = ((String)userData2).split("\t");
        Arrays.sort(split1);
        Arrays.sort(split2);
        return Arrays.equals(split1, split2);
    }

    public static void flipCoordinates(Geometry g) {
        g.apply(new CoordinateSequenceFilter(){

            public void filter(CoordinateSequence seq, int i) {
                double oldX = seq.getCoordinate((int)i).x;
                double oldY = seq.getCoordinateCopy((int)i).y;
                seq.getCoordinate(i).setX(oldY);
                seq.getCoordinate(i).setY(oldX);
            }

            public boolean isGeometryChanged() {
                return true;
            }

            public boolean isDone() {
                return false;
            }
        });
    }

    public static Geometry getInteriorPoint(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return geometry.getInteriorPoint();
    }

    public static Geometry getNthPoint(LineString lineString, int n) {
        if (lineString == null || n == 0) {
            return null;
        }
        int p = lineString.getNumPoints();
        if (Math.abs(n) > p) {
            return null;
        }
        Coordinate[] nthCoordinate = new Coordinate[]{n > 0 ? lineString.getCoordinates()[n - 1] : lineString.getCoordinates()[p + n]};
        return new Point((CoordinateSequence)new CoordinateArraySequence(nthCoordinate), lineString.getFactory());
    }

    public static Geometry getExteriorRing(Geometry geometry) {
        try {
            Polygon polygon = (Polygon)geometry;
            return polygon.getExteriorRing();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static String getEWKT(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        int srid = geometry.getSRID();
        String sridString = "";
        if (srid != 0) {
            sridString = "SRID=" + String.valueOf(srid) + ";";
        }
        return sridString + new WKTWriter(GeomUtils.getDimension(geometry)).write(geometry);
    }

    public static String getWKT(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return new WKTWriter(GeomUtils.getDimension(geometry)).write(geometry);
    }

    public static byte[] getEWKB(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        int endian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? 1 : 2;
        WKBWriter writer = new WKBWriter(GeomUtils.getDimension(geometry), endian, geometry.getSRID() != 0);
        return writer.write(geometry);
    }

    public static byte[] getWKB(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        int endian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? 1 : 2;
        WKBWriter writer = new WKBWriter(GeomUtils.getDimension(geometry), endian, false);
        return writer.write(geometry);
    }

    public static Geometry get2dGeom(Geometry geom) {
        Coordinate[] coordinates = geom.getCoordinates();
        GeometryFactory geometryFactory = new GeometryFactory();
        CoordinateSequence sequence = geometryFactory.getCoordinateSequenceFactory().create(coordinates);
        if (sequence.getDimension() > 2) {
            int i;
            for (i = 0; i < coordinates.length; ++i) {
                sequence.setOrdinate(i, 2, Double.NaN);
            }
            if (sequence.getDimension() == 4) {
                for (i = 0; i < coordinates.length; ++i) {
                    sequence.setOrdinate(i, 3, Double.NaN);
                }
            }
        }
        geom.geometryChanged();
        return geom;
    }

    public static Geometry buildArea(Geometry geom) {
        if (geom == null || geom.isEmpty()) {
            return geom;
        }
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(geom);
        List polygons = (List)polygonizer.getPolygons();
        if (polygons.isEmpty()) {
            return null;
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        int srid = geom.getSRID();
        Map<Polygon, Polygon> parentMap = GeomUtils.findFaceHoles(polygons);
        ArrayList<Polygon> facesWithEvenAncestors = new ArrayList<Polygon>();
        for (Polygon face : polygons) {
            face.normalize();
            if (GeomUtils.countParents(parentMap, face) % 2 != 0) continue;
            facesWithEvenAncestors.add(face);
        }
        UnaryUnionOp unaryUnionOp = new UnaryUnionOp(facesWithEvenAncestors);
        Geometry outputGeom = unaryUnionOp.union();
        if (outputGeom != null) {
            outputGeom.normalize();
            outputGeom.setSRID(srid);
        }
        return outputGeom;
    }

    public static int getDimension(Geometry geometry) {
        return geometry.getCoordinate() != null && !Double.isNaN(geometry.getCoordinate().getZ()) ? 3 : 2;
    }

    public static boolean geometryIsHomogeneous(Geometry geometry) {
        int dimension = geometry.getDimension();
        if (!geometry.isEmpty()) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                if (dimension == geometry.getGeometryN(i).getDimension()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean geometryIsPuntal(Geometry geometry) {
        if (geometry instanceof Puntal) {
            return true;
        }
        return GeomUtils.geometryIsHomogeneous(geometry) && geometry.getDimension() == 0;
    }

    public static boolean geometryIsLineal(Geometry geometry) {
        if (geometry instanceof Lineal) {
            return true;
        }
        return GeomUtils.geometryIsHomogeneous(geometry) && geometry.getDimension() == 1;
    }

    public static boolean geometryIsPolygonal(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return true;
        }
        return GeomUtils.geometryIsHomogeneous(geometry) && geometry.getDimension() == 2;
    }

    public static boolean isDuplicate(Geometry left, Geometry right, HalfOpenRectangle extent) {
        Point referencePoint;
        if (left instanceof Point || right instanceof Point) {
            return false;
        }
        Envelope intersection = left.getEnvelopeInternal().intersection(right.getEnvelopeInternal());
        return !intersection.isNull() && !extent.contains(referencePoint = left.getFactory().createPoint(new Coordinate(intersection.getMinX(), intersection.getMinY())));
    }

    private static Map<Polygon, Polygon> findFaceHoles(List<Polygon> faces) {
        HashMap<Polygon, Polygon> parentMap = new HashMap<Polygon, Polygon>();
        faces.sort(Comparator.comparing(p -> p.getEnvelope().getArea()).reversed());
        for (int i = 0; i < faces.size(); ++i) {
            Polygon face = faces.get(i);
            int nHoles = face.getNumInteriorRing();
            for (int h = 0; h < nHoles; ++h) {
                LinearRing hole = face.getInteriorRingN(h);
                for (int j = i + 1; j < faces.size(); ++j) {
                    LinearRing face2ExteriorRing;
                    Polygon face2 = faces.get(j);
                    if (parentMap.containsKey(face2) || !(face2ExteriorRing = face2.getExteriorRing()).equals((Geometry)hole)) continue;
                    parentMap.put(face2, face);
                }
            }
        }
        return parentMap;
    }

    private static int countParents(Map<Polygon, Polygon> parentMap, Polygon face) {
        int pCount = 0;
        while (parentMap.containsKey(face)) {
            ++pCount;
            face = parentMap.get(face);
        }
        return pCount;
    }

    public static <T extends Geometry> List<Geometry> extractGeometryCollection(Geometry geom, Class<T> geomType) {
        ArrayList<Geometry> leafs = new ArrayList<Geometry>();
        if (!(geom instanceof GeometryCollection)) {
            if (geomType.isAssignableFrom(geom.getClass())) {
                leafs.add(geom);
            }
            return leafs;
        }
        LinkedList<GeometryCollection> parents = new LinkedList<GeometryCollection>();
        parents.add((GeometryCollection)geom);
        while (!parents.isEmpty()) {
            GeometryCollection parent = (GeometryCollection)parents.removeFirst();
            for (int i = 0; i < parent.getNumGeometries(); ++i) {
                Geometry child = parent.getGeometryN(i);
                if (child instanceof GeometryCollection) {
                    parents.add((GeometryCollection)child);
                    continue;
                }
                if (!geomType.isAssignableFrom(child.getClass())) continue;
                leafs.add(child);
            }
        }
        return leafs;
    }

    public static List<Geometry> extractGeometryCollection(Geometry geom) {
        return GeomUtils.extractGeometryCollection(geom, Geometry.class);
    }

    public static Geometry[] getSubGeometries(Geometry geom) {
        Geometry[] geometries = new Geometry[geom.getNumGeometries()];
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            geometries[i] = geom.getGeometryN(i);
        }
        return geometries;
    }

    public static Geometry get3DGeom(Geometry geometry, double zValue) {
        Coordinate[] coordinates = geometry.getCoordinates();
        if (coordinates.length == 0) {
            return geometry;
        }
        for (int i = 0; i < coordinates.length; ++i) {
            boolean is3d;
            boolean bl = is3d = !Double.isNaN(coordinates[i].z);
            if (is3d) continue;
            coordinates[i].setZ(zValue);
        }
        geometry.geometryChanged();
        return geometry;
    }

    public static int getPolygonNumRings(Polygon polygon) {
        LinearRing shell = polygon.getExteriorRing();
        if (shell == null || shell.isEmpty()) {
            return 0;
        }
        return 1 + polygon.getNumInteriorRing();
    }

    public static void translateGeom(Geometry geometry, double deltaX, double deltaY, double deltaZ) {
        Coordinate[] coordinates = geometry.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate currCoordinate = coordinates[i];
            currCoordinate.setX(currCoordinate.getX() + deltaX);
            currCoordinate.setY(currCoordinate.getY() + deltaY);
            if (Double.isNaN(currCoordinate.z)) continue;
            currCoordinate.setZ(currCoordinate.getZ() + deltaZ);
        }
        if (deltaX != 0.0 || deltaY != 0.0 || deltaZ != 0.0) {
            geometry.geometryChanged();
        }
    }
}

