/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.GeometryType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.wololo.geojson.Feature;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.jts2geojson.GeoJSONReader;

public class FormatUtils<T extends Geometry>
implements Serializable {
    static final Logger logger = Logger.getLogger(FormatUtils.class);
    protected final int startOffset;
    protected final int endOffset;
    protected final FileDataSplitter splitter;
    protected final boolean carryInputData;
    protected String otherAttributes = "";
    protected GeometryType geometryType = null;
    protected transient GeometryFactory factory = new GeometryFactory();
    protected transient GeoJSONReader geoJSONReader = new GeoJSONReader();
    protected transient WKTReader wktReader = new WKTReader();
    boolean allowTopologicallyInvalidGeometries;
    boolean skipSyntacticallyInvalidGeometries;

    public FormatUtils(int startOffset, int endOffset, FileDataSplitter splitter, boolean carryInputData, GeometryType geometryType) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.splitter = splitter;
        this.carryInputData = carryInputData;
        this.geometryType = geometryType;
        this.allowTopologicallyInvalidGeometries = true;
        this.skipSyntacticallyInvalidGeometries = false;
        assert (geometryType != null || splitter == FileDataSplitter.WKB || splitter == FileDataSplitter.WKT || splitter == FileDataSplitter.GEOJSON);
    }

    public FormatUtils(FileDataSplitter splitter, boolean carryInputData) {
        this(0, -1, splitter, carryInputData, null);
    }

    public FormatUtils(FileDataSplitter splitter, boolean carryInputData, GeometryType geometryType) {
        this(0, -1, splitter, carryInputData, geometryType);
    }

    public static List<String> readGeoJsonPropertyNames(String geoJson) {
        if ((geoJson.contains("Feature") || geoJson.contains("feature") || geoJson.contains("FEATURE")) && geoJson.contains("properties")) {
            Feature feature = (Feature)GeoJSONFactory.create(geoJson);
            if (Objects.isNull(feature.getId())) {
                return new ArrayList<String>(feature.getProperties().keySet());
            }
            ArrayList<String> propertyList = new ArrayList<String>(Arrays.asList("id"));
            for (String geoJsonProperty : feature.getProperties().keySet()) {
                propertyList.add(geoJsonProperty);
            }
            return propertyList;
        }
        logger.warn((Object)"[Sedona] The GeoJSON file doesn't have feature properties");
        return null;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.factory = new GeometryFactory();
        this.wktReader = new WKTReader();
        this.geoJSONReader = new GeoJSONReader();
    }

    private void handleNonSpatialDataToGeometry(Geometry geometry, List<String> splitedGeometryData) {
        LinkedList<String> splitedGeometryDataList = new LinkedList<String>(splitedGeometryData);
        if (this.carryInputData) {
            if (this.splitter != FileDataSplitter.GEOJSON) {
                splitedGeometryDataList.remove(this.startOffset);
            }
            geometry.setUserData(String.join((CharSequence)"\t", splitedGeometryDataList));
        }
    }

    public Geometry readGeoJSON(String geoJson) {
        Geometry geometry;
        if (geoJson.contains("Feature")) {
            Feature feature = (Feature)GeoJSONFactory.create(geoJson);
            ArrayList<String> nonSpatialData = new ArrayList<String>();
            Map<String, Object> featurePropertiesproperties = feature.getProperties();
            if (feature.getId() != null) {
                nonSpatialData.add(feature.getId().toString());
            }
            if (featurePropertiesproperties != null) {
                for (Object property : featurePropertiesproperties.values()) {
                    if (property == null) {
                        nonSpatialData.add("null");
                        continue;
                    }
                    nonSpatialData.add(property.toString());
                }
            }
            geometry = this.geoJSONReader.read(feature.getGeometry());
            this.handleNonSpatialDataToGeometry(geometry, nonSpatialData);
        } else {
            geometry = this.geoJSONReader.read(geoJson);
        }
        return geometry;
    }

    public List<String> readPropertyNames(String geoString) {
        switch (this.splitter) {
            case GEOJSON: {
                return FormatUtils.readGeoJsonPropertyNames(geoString);
            }
        }
        return null;
    }

    public Geometry readWkt(String line) throws ParseException {
        String[] columns = line.split(this.splitter.getDelimiter());
        Geometry geometry = null;
        try {
            geometry = this.wktReader.read(columns[this.startOffset]);
        }
        catch (Exception e) {
            logger.error((Object)("[Sedona] " + e.getMessage()));
        }
        if (geometry == null) {
            return null;
        }
        this.handleNonSpatialDataToGeometry(geometry, Arrays.asList(columns));
        return geometry;
    }

    public Geometry readWkb(String line) throws ParseException {
        String[] columns = line.split(this.splitter.getDelimiter());
        byte[] aux = WKBReader.hexToBytes(columns[this.startOffset]);
        WKBReader wkbReader = new WKBReader();
        Geometry geometry = wkbReader.read(aux);
        this.handleNonSpatialDataToGeometry(geometry, Arrays.asList(columns));
        return geometry;
    }

    public Coordinate[] readCoordinates(String line) {
        String[] columns = line.split(this.splitter.getDelimiter());
        int actualEndOffset = this.endOffset >= 0 ? this.endOffset : (this.geometryType == GeometryType.POINT ? this.startOffset + 1 : columns.length - 1);
        Coordinate[] coordinates = new Coordinate[(actualEndOffset - this.startOffset + 1) / 2];
        for (int i = this.startOffset; i <= actualEndOffset; i += 2) {
            coordinates[(i - this.startOffset) / 2] = new Coordinate(Double.parseDouble(columns[i]), Double.parseDouble(columns[i + 1]));
        }
        if (this.carryInputData) {
            int i;
            boolean firstColumnFlag = true;
            this.otherAttributes = "";
            for (i = 0; i < this.startOffset; ++i) {
                if (firstColumnFlag) {
                    this.otherAttributes = this.otherAttributes + columns[i];
                    firstColumnFlag = false;
                    continue;
                }
                this.otherAttributes = this.otherAttributes + "\t" + columns[i];
            }
            for (i = actualEndOffset + 1; i < columns.length; ++i) {
                if (firstColumnFlag) {
                    this.otherAttributes = this.otherAttributes + columns[i];
                    firstColumnFlag = false;
                    continue;
                }
                this.otherAttributes = this.otherAttributes + "\t" + columns[i];
            }
        }
        return coordinates;
    }

    public <T extends Geometry> void addMultiGeometry(GeometryCollection multiGeometry, List<T> result2) {
        for (int i = 0; i < multiGeometry.getNumGeometries(); ++i) {
            Geometry geometry = multiGeometry.getGeometryN(i);
            geometry.setUserData(multiGeometry.getUserData());
            result2.add(geometry);
        }
    }

    public Geometry readGeometry(String line) throws ParseException {
        IsValidOp isvalidop;
        Geometry geometry;
        block10: {
            geometry = null;
            try {
                switch (this.splitter) {
                    case WKT: {
                        geometry = this.readWkt(line);
                        break;
                    }
                    case WKB: {
                        geometry = this.readWkb(line);
                        break;
                    }
                    case GEOJSON: {
                        geometry = this.readGeoJSON(line);
                        break;
                    }
                    default: {
                        if (this.geometryType == null) {
                            throw new IllegalArgumentException("[Sedona][FormatMapper] You must specify GeometryType when you use delimiter rather than WKB, WKT or GeoJSON");
                        }
                        geometry = this.createGeometry(this.readCoordinates(line), this.geometryType);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("[Sedona] " + e.getMessage()));
                if (this.skipSyntacticallyInvalidGeometries) break block10;
                throw e;
            }
        }
        if (geometry == null) {
            return null;
        }
        if (!this.allowTopologicallyInvalidGeometries && !(isvalidop = new IsValidOp(geometry)).isValid()) {
            geometry = null;
        }
        return geometry;
    }

    private Geometry createGeometry(Coordinate[] coordinates, GeometryType geometryType) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Geometry geometry = null;
        switch (geometryType) {
            case POINT: {
                geometry = geometryFactory.createPoint(coordinates[0]);
                break;
            }
            case POLYGON: {
                geometry = geometryFactory.createPolygon(coordinates);
                break;
            }
            case LINESTRING: {
                geometry = geometryFactory.createLineString(coordinates);
                break;
            }
            case RECTANGLE: {
                Coordinate[] polyCoordinates;
                assert (coordinates.length == 2);
                polyCoordinates = new Coordinate[]{coordinates[0], new Coordinate(coordinates[0].x, coordinates[1].y), coordinates[1], new Coordinate(coordinates[1].x, coordinates[0].y), polyCoordinates[0]};
                geometry = this.factory.createPolygon(polyCoordinates);
                break;
            }
            default: {
                geometry = geometryFactory.createPoint(coordinates[0]);
            }
        }
        if (this.carryInputData) {
            geometry.setUserData(this.otherAttributes);
        }
        return geometry;
    }

    protected void addGeometry(Geometry geometry, List<T> result2) {
        if (geometry == null) {
            return;
        }
        if (geometry instanceof MultiPoint) {
            this.addMultiGeometry((MultiPoint)geometry, result2);
        } else if (geometry instanceof MultiLineString) {
            this.addMultiGeometry((MultiLineString)geometry, result2);
        } else if (geometry instanceof MultiPolygon) {
            this.addMultiGeometry((MultiPolygon)geometry, result2);
        } else {
            result2.add(geometry);
        }
    }
}

