/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.service.jar;

import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageMode;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.service.jar.ConnectorJarStorageStrategy;
import org.apache.seatunnel.engine.server.service.jar.IsolatedConnectorJarStorageStrategy;
import org.apache.seatunnel.engine.server.service.jar.SharedConnectorJarStorageStrategy;

public class StorageStrategyFactory {
    public static ConnectorJarStorageStrategy of(ConnectorJarStorageMode connectorJarStorageMode, ConnectorJarStorageConfig connectorJarStorageConfig, SeaTunnelServer seaTunnelServer) {
        switch (connectorJarStorageMode) {
            case SHARED: {
                return new SharedConnectorJarStorageStrategy(connectorJarStorageConfig, seaTunnelServer);
            }
            case ISOLATED: {
                return new IsolatedConnectorJarStorageStrategy(connectorJarStorageConfig, seaTunnelServer);
            }
        }
        throw new IllegalArgumentException(ServerConfigOptions.CONNECTOR_JAR_STORAGE_MODE + " must in [SHARED, ISOLATED]");
    }
}

