/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.HazelcastInstanceProxy;
import com.hazelcast.instance.impl.Node;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.ConfigProvider;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.SeaTunnelNodeContext;
import org.apache.seatunnel.engine.server.telemetry.metrics.ExportsInstanceInitializer;

public class SeaTunnelServerStarter {
    public static void main(String[] args) {
        SeaTunnelServerStarter.createHazelcastInstance();
    }

    public static HazelcastInstanceImpl createHazelcastInstance(String clusterName) {
        SeaTunnelConfig seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
        seaTunnelConfig.getHazelcastConfig().setClusterName(clusterName);
        return SeaTunnelServerStarter.createHazelcastInstance(seaTunnelConfig);
    }

    public static HazelcastInstanceImpl createHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        return SeaTunnelServerStarter.createHazelcastInstance(seaTunnelConfig, null);
    }

    public static HazelcastInstanceImpl createHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig, String customInstanceName) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        return SeaTunnelServerStarter.initializeHazelcastInstance(seaTunnelConfig, customInstanceName);
    }

    private static HazelcastInstanceImpl initializeHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig, String customInstanceName) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        boolean condition = SeaTunnelServerStarter.checkTelemetryConfig(seaTunnelConfig);
        String instanceName = customInstanceName != null ? customInstanceName : HazelcastInstanceFactory.createInstanceName(seaTunnelConfig.getHazelcastConfig());
        HazelcastInstanceImpl original = ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance(seaTunnelConfig.getHazelcastConfig(), instanceName, new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
        if (condition) {
            SeaTunnelServerStarter.initTelemetryInstance(original.node);
        }
        return original;
    }

    public static HazelcastInstanceImpl createMasterAndWorkerHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        seaTunnelConfig.getEngineConfig().setClusterRole(EngineConfig.ClusterRole.MASTER_AND_WORKER);
        return ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance(seaTunnelConfig.getHazelcastConfig(), HazelcastInstanceFactory.createInstanceName(seaTunnelConfig.getHazelcastConfig()), new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
    }

    public static HazelcastInstanceImpl createMasterHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        seaTunnelConfig.getEngineConfig().setClusterRole(EngineConfig.ClusterRole.MASTER);
        return ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance(seaTunnelConfig.getHazelcastConfig(), HazelcastInstanceFactory.createInstanceName(seaTunnelConfig.getHazelcastConfig()), new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
    }

    public static HazelcastInstanceImpl createWorkerHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        seaTunnelConfig.getEngineConfig().setClusterRole(EngineConfig.ClusterRole.WORKER);
        seaTunnelConfig.getHazelcastConfig().setLiteMember(true);
        return ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance(seaTunnelConfig.getHazelcastConfig(), HazelcastInstanceFactory.createInstanceName(seaTunnelConfig.getHazelcastConfig()), new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
    }

    public static HazelcastInstanceImpl createHazelcastInstance() {
        SeaTunnelConfig seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
        return SeaTunnelServerStarter.createHazelcastInstance(seaTunnelConfig);
    }

    public static void initTelemetryInstance(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        ExportsInstanceInitializer.init(node);
    }

    private static boolean checkTelemetryConfig(SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig.getEngineConfig().getTelemetryConfig().getMetric().isEnabled()) {
            seaTunnelConfig.getHazelcastConfig().getProperties().setProperty("hazelcast.jmx", "true");
            return true;
        }
        return false;
    }
}

