/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.engine.imap.storage.api.IMapStorage;
import org.apache.seatunnel.engine.imap.storage.api.exception.IMapStorageException;
import org.apache.seatunnel.engine.imap.storage.file.bean.IMapFileData;
import org.apache.seatunnel.engine.imap.storage.file.common.WALReader;
import org.apache.seatunnel.engine.imap.storage.file.config.AbstractConfiguration;
import org.apache.seatunnel.engine.imap.storage.file.config.FileConfiguration;
import org.apache.seatunnel.engine.imap.storage.file.disruptor.WALDisruptor;
import org.apache.seatunnel.engine.imap.storage.file.disruptor.WALEventType;
import org.apache.seatunnel.engine.imap.storage.file.future.RequestFuture;
import org.apache.seatunnel.engine.imap.storage.file.future.RequestFutureCache;
import org.apache.seatunnel.engine.serializer.api.Serializer;
import org.apache.seatunnel.engine.serializer.protobuf.ProtoStuffSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMapFileStorage
implements IMapStorage {
    private static final Logger log = LoggerFactory.getLogger(IMapFileStorage.class);
    private static final String STORAGE_TYPE_KEY = "storage.type";
    public FileSystem fs;
    public String namespace;
    public String region;
    public String businessName;
    public String clusterName;
    public long writDataTimeoutMilliseconds;
    WALDisruptor walDisruptor;
    Serializer serializer;
    private String businessRootPath = null;
    public static final int DEFAULT_ARCHIVE_WAIT_TIME_MILLISECONDS = 60000;
    public static final int DEFAULT_QUERY_LIST_SIZE = 256;
    public static final long DEFAULT_WRITE_DATA_TIMEOUT_MILLISECONDS = 60000L;
    private Configuration conf;
    private FileConfiguration fileConfiguration;

    @Override
    public void initialize(Map<String, Object> configuration) {
        Configuration hadoopConf;
        this.checkInitStorageProperties(configuration);
        String storageType = String.valueOf(configuration.getOrDefault(STORAGE_TYPE_KEY, FileConfiguration.HDFS.toString()));
        this.fileConfiguration = FileConfiguration.valueOf(storageType.toUpperCase());
        AbstractConfiguration fileConfiguration = this.fileConfiguration.getConfiguration();
        Map<String, String> stringMap = configuration.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
        this.conf = hadoopConf = fileConfiguration.buildConfiguration(stringMap);
        this.namespace = (String)configuration.getOrDefault("namespace", "/seatunnel-imap");
        this.businessName = (String)configuration.get("businessName");
        this.clusterName = (String)configuration.get("clusterName");
        this.writDataTimeoutMilliseconds = (Long)configuration.getOrDefault("writeDataTimeoutMilliseconds", 60000L);
        this.region = String.valueOf(System.nanoTime());
        this.businessRootPath = this.namespace + "/" + this.clusterName + "/" + this.businessName + "/";
        try {
            this.fs = FileSystem.get((Configuration)hadoopConf);
            this.fs.setWriteChecksum(false);
        }
        catch (IOException e) {
            throw new IMapStorageException("Failed to get file system", e);
        }
        this.serializer = new ProtoStuffSerializer();
        this.walDisruptor = new WALDisruptor(this.fs, FileConfiguration.valueOf(storageType.toUpperCase()), this.businessRootPath + this.region + "/", this.serializer);
    }

    @Override
    public boolean store(Object key, Object value) {
        IMapFileData data;
        try {
            data = this.parseToIMapFileData(key, value);
        }
        catch (IOException e) {
            log.error("parse to IMapFileData error, key is {}, value is {}", key, value, e);
            return false;
        }
        long requestId = this.sendToDisruptorQueue(data, WALEventType.APPEND);
        return this.queryExecuteStatus(requestId);
    }

    @Override
    public Set<Object> storeAll(Map<Object, Object> map) {
        HashMap<Long, Object> requestMap = new HashMap<Long, Object>(map.size());
        HashSet<Object> failures = new HashSet<Object>();
        map.forEach((key, value) -> {
            try {
                IMapFileData data = this.parseToIMapFileData(key, value);
                long requestId = this.sendToDisruptorQueue(data, WALEventType.APPEND);
                requestMap.put(requestId, key);
            }
            catch (IOException e) {
                log.error("parse to IMapFileData error", e);
                failures.add(key);
            }
        });
        return this.batchQueryExecuteFailsStatus(requestMap, failures);
    }

    @Override
    public boolean delete(Object key) {
        IMapFileData data;
        try {
            data = this.buildDeleteIMapFileData(key);
        }
        catch (IOException e) {
            log.error("parse to IMapFileData error, key is {} ", key, (Object)e);
            return false;
        }
        long requestId = this.sendToDisruptorQueue(data, WALEventType.APPEND);
        return this.queryExecuteStatus(requestId);
    }

    @Override
    public Set<Object> deleteAll(Collection<Object> keys) {
        HashMap<Long, Object> requestMap = new HashMap<Long, Object>(keys.size());
        HashSet<Object> failures = new HashSet<Object>();
        keys.forEach(key -> {
            try {
                IMapFileData data = this.buildDeleteIMapFileData(key);
                long requestId = this.sendToDisruptorQueue(data, WALEventType.APPEND);
                this.walDisruptor.tryAppendPublish(data, requestId);
                requestMap.put(requestId, data);
            }
            catch (IOException e) {
                log.error("parse to IMapFileData error", e);
                failures.add(key);
            }
        });
        return this.batchQueryExecuteFailsStatus(requestMap, failures);
    }

    @Override
    public Map<Object, Object> loadAll() {
        try {
            WALReader reader = new WALReader(this.fs, this.fileConfiguration, this.serializer);
            return reader.loadAllData(new Path(this.businessRootPath), new HashSet<Object>());
        }
        catch (IOException e) {
            throw new IMapStorageException("load all data error", e);
        }
    }

    @Override
    public Set<Object> loadAllKeys() {
        try {
            WALReader reader = new WALReader(this.fs, this.fileConfiguration, this.serializer);
            return reader.loadAllKeys(new Path(this.businessRootPath));
        }
        catch (IOException e) {
            throw new IMapStorageException(e, "load all keys error parent path is {}", e, this.businessRootPath);
        }
    }

    @Override
    public void destroy(boolean deleteAllFileFlag) {
        log.info("start destroy IMapFileStorage, businessName is {}, cluster name is {}", (Object)this.businessName, (Object)this.region);
        try {
            this.walDisruptor.close();
        }
        catch (IOException e) {
            log.error("close walDisruptor error", e);
        }
        if (deleteAllFileFlag) {
            String parentPath = this.businessRootPath;
            try {
                this.fs.delete(new Path(parentPath), true);
            }
            catch (IOException e) {
                log.error("destroy IMapFileStorage error,businessName is {}, cluster name is {}", this.businessName, this.region, e);
            }
        }
    }

    private IMapFileData parseToIMapFileData(Object key, Object value) throws IOException {
        return IMapFileData.builder().key(this.serializer.serialize(key)).keyClassName(key.getClass().getName()).value(this.serializer.serialize(value)).valueClassName(value.getClass().getName()).timestamp(System.currentTimeMillis()).deleted(false).build();
    }

    private IMapFileData buildDeleteIMapFileData(Object key) throws IOException {
        return IMapFileData.builder().key(this.serializer.serialize(key)).keyClassName(key.getClass().getName()).timestamp(System.currentTimeMillis()).deleted(true).build();
    }

    private long sendToDisruptorQueue(IMapFileData data, WALEventType type) {
        long requestId = RequestFutureCache.getRequestId();
        RequestFuture requestFuture = new RequestFuture();
        RequestFutureCache.put(requestId, requestFuture);
        this.walDisruptor.tryPublish(data, type, requestId);
        return requestId;
    }

    private boolean queryExecuteStatus(long requestId) {
        return this.queryExecuteStatus(requestId, this.writDataTimeoutMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queryExecuteStatus(long requestId, long timeout) {
        RequestFuture requestFuture = RequestFutureCache.get(requestId);
        try {
            if (requestFuture.isDone() || Boolean.TRUE.equals(requestFuture.get(timeout, TimeUnit.MILLISECONDS))) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("wait for write status error", e);
        }
        finally {
            RequestFutureCache.remove(requestId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> batchQueryExecuteFailsStatus(Map<Long, Object> requestMap, Set<Object> failures) {
        for (Map.Entry<Long, Object> entry : requestMap.entrySet()) {
            boolean success = false;
            RequestFuture requestFuture = RequestFutureCache.get(entry.getKey());
            try {
                if (requestFuture.isDone() || Boolean.TRUE.equals(requestFuture.get())) {
                    success = true;
                }
            }
            catch (Exception e) {
                log.error("wait for write status error", e);
            }
            finally {
                RequestFutureCache.remove(entry.getKey());
            }
            if (success) continue;
            failures.add(entry.getValue());
        }
        return failures;
    }

    private void checkInitStorageProperties(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("init file storage properties is empty");
        }
        List<String> requiredProperties = Arrays.asList("businessName", "clusterName");
        for (String requiredProperty : requiredProperties) {
            if (properties.containsKey(requiredProperty)) continue;
            throw new IllegalArgumentException("init file storage properties is not contains " + requiredProperty);
        }
    }
}

