/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.actions;

import com.hazelcast.collection.IQueue;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.HazelcastInstance;
import java.io.Serializable;
import java.util.Map;
import org.apache.seatunnel.api.table.type.Record;

public abstract class ShuffleStrategy
implements Serializable {
    private static final int DEFAULT_QUEUE_SIZE = 2048;
    private static final int DEFAULT_QUEUE_BACKUP_COUNT = 0;
    private static final int DEFAULT_QUEUE_ASYNC_BACKUP_COUNT = 0;
    protected long jobId;
    protected int inputPartitions;
    protected int queueMaxSize;
    protected int queueBackupCount;
    protected int queueAsyncBackupCount;
    protected int queueEmptyQueueTtl;

    public ShuffleStrategy() {
    }

    public abstract Map<String, IQueue<Record<?>>> createShuffles(HazelcastInstance var1, int var2, int var3);

    public abstract String createShuffleKey(Record<?> var1, int var2, int var3);

    public abstract IQueue<Record<?>>[] getShuffles(HazelcastInstance var1, int var2, int var3);

    protected IQueue<Record<?>> getIQueue(HazelcastInstance hazelcast, String queueName) {
        QueueConfig targetQueueConfig = hazelcast.getConfig().getQueueConfig(queueName);
        targetQueueConfig.setMaxSize(this.queueMaxSize);
        targetQueueConfig.setBackupCount(this.queueBackupCount);
        targetQueueConfig.setAsyncBackupCount(this.queueAsyncBackupCount);
        targetQueueConfig.setEmptyQueueTtl(this.queueEmptyQueueTtl);
        return hazelcast.getQueue(queueName);
    }

    private static int $default$queueMaxSize() {
        return 2048;
    }

    private static int $default$queueBackupCount() {
        return 0;
    }

    private static int $default$queueAsyncBackupCount() {
        return 0;
    }

    protected ShuffleStrategy(ShuffleStrategyBuilder<?, ?> b) {
        this.jobId = ((ShuffleStrategyBuilder)b).jobId;
        this.inputPartitions = ((ShuffleStrategyBuilder)b).inputPartitions;
        this.queueMaxSize = ((ShuffleStrategyBuilder)b).queueMaxSize$set ? ((ShuffleStrategyBuilder)b).queueMaxSize$value : ShuffleStrategy.$default$queueMaxSize();
        this.queueBackupCount = ((ShuffleStrategyBuilder)b).queueBackupCount$set ? ((ShuffleStrategyBuilder)b).queueBackupCount$value : ShuffleStrategy.$default$queueBackupCount();
        this.queueAsyncBackupCount = ((ShuffleStrategyBuilder)b).queueAsyncBackupCount$set ? ((ShuffleStrategyBuilder)b).queueAsyncBackupCount$value : ShuffleStrategy.$default$queueAsyncBackupCount();
        this.queueEmptyQueueTtl = ((ShuffleStrategyBuilder)b).queueEmptyQueueTtl;
    }

    public long getJobId() {
        return this.jobId;
    }

    public int getInputPartitions() {
        return this.inputPartitions;
    }

    public int getQueueMaxSize() {
        return this.queueMaxSize;
    }

    public int getQueueBackupCount() {
        return this.queueBackupCount;
    }

    public int getQueueAsyncBackupCount() {
        return this.queueAsyncBackupCount;
    }

    public int getQueueEmptyQueueTtl() {
        return this.queueEmptyQueueTtl;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public void setInputPartitions(int inputPartitions) {
        this.inputPartitions = inputPartitions;
    }

    public void setQueueMaxSize(int queueMaxSize) {
        this.queueMaxSize = queueMaxSize;
    }

    public void setQueueBackupCount(int queueBackupCount) {
        this.queueBackupCount = queueBackupCount;
    }

    public void setQueueAsyncBackupCount(int queueAsyncBackupCount) {
        this.queueAsyncBackupCount = queueAsyncBackupCount;
    }

    public void setQueueEmptyQueueTtl(int queueEmptyQueueTtl) {
        this.queueEmptyQueueTtl = queueEmptyQueueTtl;
    }

    public String toString() {
        return "ShuffleStrategy(jobId=" + this.getJobId() + ", inputPartitions=" + this.getInputPartitions() + ", queueMaxSize=" + this.getQueueMaxSize() + ", queueBackupCount=" + this.getQueueBackupCount() + ", queueAsyncBackupCount=" + this.getQueueAsyncBackupCount() + ", queueEmptyQueueTtl=" + this.getQueueEmptyQueueTtl() + ")";
    }

    public static abstract class ShuffleStrategyBuilder<C extends ShuffleStrategy, B extends ShuffleStrategyBuilder<C, B>> {
        private long jobId;
        private int inputPartitions;
        private boolean queueMaxSize$set;
        private int queueMaxSize$value;
        private boolean queueBackupCount$set;
        private int queueBackupCount$value;
        private boolean queueAsyncBackupCount$set;
        private int queueAsyncBackupCount$value;
        private int queueEmptyQueueTtl;

        protected B $fillValuesFrom(C instance) {
            ShuffleStrategyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ShuffleStrategy instance, ShuffleStrategyBuilder<?, ?> b) {
            b.jobId(instance.jobId);
            b.inputPartitions(instance.inputPartitions);
            b.queueMaxSize(instance.queueMaxSize);
            b.queueBackupCount(instance.queueBackupCount);
            b.queueAsyncBackupCount(instance.queueAsyncBackupCount);
            b.queueEmptyQueueTtl(instance.queueEmptyQueueTtl);
        }

        protected abstract B self();

        public abstract C build();

        public B jobId(long jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public B inputPartitions(int inputPartitions) {
            this.inputPartitions = inputPartitions;
            return this.self();
        }

        public B queueMaxSize(int queueMaxSize) {
            this.queueMaxSize$value = queueMaxSize;
            this.queueMaxSize$set = true;
            return this.self();
        }

        public B queueBackupCount(int queueBackupCount) {
            this.queueBackupCount$value = queueBackupCount;
            this.queueBackupCount$set = true;
            return this.self();
        }

        public B queueAsyncBackupCount(int queueAsyncBackupCount) {
            this.queueAsyncBackupCount$value = queueAsyncBackupCount;
            this.queueAsyncBackupCount$set = true;
            return this.self();
        }

        public B queueEmptyQueueTtl(int queueEmptyQueueTtl) {
            this.queueEmptyQueueTtl = queueEmptyQueueTtl;
            return this.self();
        }

        public String toString() {
            return "ShuffleStrategy.ShuffleStrategyBuilder(jobId=" + this.jobId + ", inputPartitions=" + this.inputPartitions + ", queueMaxSize$value=" + this.queueMaxSize$value + ", queueBackupCount$value=" + this.queueBackupCount$value + ", queueAsyncBackupCount$value=" + this.queueAsyncBackupCount$value + ", queueEmptyQueueTtl=" + this.queueEmptyQueueTtl + ")";
        }
    }
}

