/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.seatunnel.common.config.ConfigRuntimeException;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.command.CommandArgs;
import org.apache.seatunnel.core.starter.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnel {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnel.class);

    public static <T extends CommandArgs> void run(Command<T> command) throws CommandException {
        try {
            command.execute();
        }
        catch (ConfigRuntimeException e) {
            SeaTunnel.showConfigError(e);
            throw e;
        }
        catch (Exception e) {
            SeaTunnel.showFatalError(e);
            throw e;
        }
    }

    private static void showConfigError(Throwable throwable) {
        log.error("\n\n===============================================================================\n\n");
        String errorMsg = throwable.getMessage();
        log.error("Config Error:\n");
        log.error("Reason: {} \n", (Object)errorMsg);
        log.error("\n===============================================================================\n\n\n");
    }

    private static void showFatalError(Throwable throwable) {
        log.error("\n\n===============================================================================\n\n");
        String errorMsg = throwable.getMessage();
        log.error("Fatal Error, \n");
        log.error("Please submit bug report in https://github.com/apache/seatunnel/issues\n");
        log.error("Reason:{} \n", (Object)errorMsg);
        log.error("Exception StackTrace:{} ", (Object)ExceptionUtils.getStackTrace(throwable));
        log.error("\n===============================================================================\n\n\n");
    }
}

