/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink;

import java.util.HashSet;
import java.util.Set;

public enum TablePlaceholder {
    REPLACE_DATABASE_NAME_KEY("database_name"),
    REPLACE_SCHEMA_NAME_KEY("schema_name"),
    REPLACE_SCHEMA_FULL_NAME_KEY("schema_full_name"),
    REPLACE_TABLE_NAME_KEY("table_name"),
    REPLACE_TABLE_FULL_NAME_KEY("table_full_name"),
    REPLACE_PRIMARY_KEY("primary_key"),
    REPLACE_UNIQUE_KEY("unique_key"),
    REPLACE_FIELD_NAMES_KEY("field_names");

    private static Set<String> PLACEHOLDER_KEYS;
    private final String key;

    private TablePlaceholder(String placeholder) {
        this.key = placeholder;
    }

    public String getPlaceholder() {
        return this.key;
    }

    public static boolean isSystemPlaceholder(String str) {
        return PLACEHOLDER_KEYS.contains(str);
    }

    static {
        PLACEHOLDER_KEYS = new HashSet<String>();
        for (TablePlaceholder placeholder : TablePlaceholder.values()) {
            PLACEHOLDER_KEYS.add(placeholder.getPlaceholder());
        }
    }
}

