/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);
    private static final ObjectMapper JACKSON_MAPPER = new ObjectMapper();

    public static <T> T convertValue(Object rawValue, Option<T> option) {
        TypeReference<T> typeReference = option.typeReference();
        if (typeReference.getType() instanceof Class) {
            Class clazz = (Class)typeReference.getType();
            if (clazz.equals(rawValue.getClass())) {
                return (T)rawValue;
            }
            try {
                return ConfigUtil.convertValue(rawValue, clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            return JACKSON_MAPPER.readValue(ConfigUtil.convertToJsonString(rawValue), typeReference);
        }
        catch (JsonProcessingException e) {
            if (typeReference.getType() instanceof ParameterizedType && List.class.equals((Object)((ParameterizedType)typeReference.getType()).getRawType())) {
                try {
                    log.warn("Option '{}' is a List, and it is recommended to configure it as [\"string1\",\"string2\"]; we will only use ',' to split the String into a list.", (Object)option.key());
                    return (T)ConfigUtil.convertToList(rawValue, (Class)((ParameterizedType)typeReference.getType()).getActualTypeArguments()[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(String.format("Json parsing exception, value '%s', and expected type '%s'", rawValue, typeReference.getType().getTypeName()), e);
        }
    }

    static <T> List<T> convertToList(Object rawValue, Class<T> clazz) {
        if (rawValue instanceof List) {
            return ((List)rawValue).stream().map(value -> ConfigUtil.convertValue((Object)ConfigUtil.convertToJsonString(value), clazz)).collect(Collectors.toList());
        }
        return Arrays.stream(rawValue.toString().split(",")).map(String::trim).map(value -> ConfigUtil.convertValue(value, clazz)).collect(Collectors.toList());
    }

    static <T> T convertValue(Object rawValue, Class<T> clazz) {
        if (Boolean.class.equals(clazz)) {
            return (T)ConfigUtil.convertToBoolean(rawValue);
        }
        if (clazz.isEnum()) {
            return ConfigUtil.convertToEnum(rawValue, clazz);
        }
        if (String.class.equals(clazz)) {
            return (T)ConfigUtil.convertToJsonString(rawValue);
        }
        if (Integer.class.equals(clazz)) {
            return (T)ConfigUtil.convertToInt(rawValue);
        }
        if (Long.class.equals(clazz)) {
            return (T)ConfigUtil.convertToLong(rawValue);
        }
        if (Float.class.equals(clazz)) {
            return (T)ConfigUtil.convertToFloat(rawValue);
        }
        if (Double.class.equals(clazz)) {
            return (T)ConfigUtil.convertToDouble(rawValue);
        }
        if (Object.class.equals(clazz)) {
            return (T)rawValue;
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz);
    }

    static Integer convertToInt(Object o) {
        if (o.getClass() == Integer.class) {
            return (Integer)o;
        }
        if (o.getClass() == Long.class) {
            long value = (Long)o;
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the integer type.", value));
        }
        return Integer.parseInt(o.toString());
    }

    static Long convertToLong(Object o) {
        if (o.getClass() == Long.class) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class) {
            return ((Integer)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    static Float convertToFloat(Object o) {
        if (o.getClass() == Float.class) {
            return (Float)o;
        }
        if (o.getClass() == Double.class) {
            double value = (Double)o;
            if (value == 0.0 || value >= (double)1.4E-45f && value <= 3.4028234663852886E38 || value >= -3.4028234663852886E38 && value <= (double)-1.4E-45f) {
                return Float.valueOf((float)value);
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the float type.", value));
        }
        return Float.valueOf(Float.parseFloat(o.toString()));
    }

    static Double convertToDouble(Object o) {
        if (o.getClass() == Double.class) {
            return (Double)o;
        }
        if (o.getClass() == Float.class) {
            return ((Float)o).doubleValue();
        }
        return Double.parseDouble(o.toString());
    }

    static Boolean convertToBoolean(Object o) {
        switch (o.toString().toUpperCase()) {
            case "TRUE": {
                return true;
            }
            case "FALSE": {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option for boolean: %s. Expected either true or false(case insensitive)", o));
    }

    static <E extends Enum<?>> E convertToEnum(Object o, Class<E> clazz) {
        return (E)Arrays.stream((Enum[])clazz.getEnumConstants()).filter(e -> e.toString().toUpperCase(Locale.ROOT).equals(o.toString().toUpperCase(Locale.ROOT))).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Could not parse value for enum %s. Expected one of: [%s]", clazz, Arrays.toString(clazz.getEnumConstants()))));
    }

    public static String convertToJsonString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        try {
            return JACKSON_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Could not parse json, value: %s", o));
        }
    }

    public static String convertToJsonString(Config config) {
        return ConfigUtil.convertToJsonString(config.root().unwrapped());
    }

    public static Config convertToConfig(String configJson) {
        return ConfigFactory.parseString(configJson);
    }
}

