/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.projection.impl;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.projection.impl.ProjectionDataSerializerHook;
import com.hazelcast.query.impl.Extractable;
import java.io.IOException;
import java.util.Objects;

public final class SingleAttributeProjection<I, O>
implements Projection<I, O>,
IdentifiedDataSerializable {
    private String attributePath;

    SingleAttributeProjection() {
    }

    public SingleAttributeProjection(String attributePath) {
        Preconditions.checkHasText(attributePath, "attributePath must not be null or empty");
        Preconditions.checkFalse(attributePath.contains("[any]"), "attributePath must not contain [any] operators");
        this.attributePath = attributePath;
    }

    @Override
    public O transform(I input) {
        if (input instanceof Extractable) {
            return (O)((Extractable)input).getAttributeValue(this.attributePath);
        }
        throw new IllegalArgumentException("The given map entry is not extractable");
    }

    @Override
    public int getFactoryId() {
        return ProjectionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.attributePath);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributePath = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleAttributeProjection that = (SingleAttributeProjection)o;
        return Objects.equals(this.attributePath, that.attributePath);
    }

    public int hashCode() {
        return Objects.hash(this.attributePath);
    }
}

