/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapChunk;
import com.hazelcast.map.impl.operation.MapChunkContext;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.function.BooleanSupplier;

class MapChunkSupplier
implements ChunkSupplier {
    protected final MapChunkContext context;
    protected BooleanSupplier isEndOfChunk;
    private final int partitionId;
    private final int replicaIndex;
    private final MapServiceContext mapServiceContext;
    private volatile int chunkNumber;

    MapChunkSupplier(MapServiceContext mapServiceContext, ServiceNamespace namespace, int partitionId, int replicaIndex) {
        this.mapServiceContext = mapServiceContext;
        this.replicaIndex = replicaIndex;
        this.partitionId = partitionId;
        this.context = this.createMapChunkContext(mapServiceContext, namespace, partitionId);
    }

    protected MapChunkContext createMapChunkContext(MapServiceContext mapServiceContext, ServiceNamespace namespace, int partitionId) {
        return new MapChunkContext(mapServiceContext, partitionId, namespace);
    }

    protected Operation createChunkOperation(int chunkNumber) {
        return new MapChunk(this.context, chunkNumber, this.isEndOfChunk);
    }

    @Override
    public final void signalEndOfChunkWith(BooleanSupplier isEndOfChunk) {
        this.isEndOfChunk = isEndOfChunk;
    }

    @Override
    public final Operation next() {
        assert (this.isEndOfChunk != null) : "isEndOfChunk must be set before";
        ++this.chunkNumber;
        return this.createChunkOperation(this.chunkNumber).setPartitionId(this.partitionId).setReplicaIndex(this.replicaIndex).setServiceName("hz:impl:mapService").setNodeEngine(this.mapServiceContext.getNodeEngine());
    }

    @Override
    public final boolean hasNext() {
        if (this.chunkNumber == 0) {
            return true;
        }
        return this.context.hasMoreChunks();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + '{' + "partitionId=" + this.partitionId + ", chunkNumber=" + this.chunkNumber + ", mapName=" + this.context.getMapName() + '}';
    }
}

