/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultCompactWriter
implements CompactWriter {
    private final CompactStreamSerializer serializer;
    private final Schema schema;
    private final BufferObjectDataOutput out;
    private final int dataStartPosition;
    private final int[] fieldOffsets;
    private final boolean includeSchemaOnBinary;

    public DefaultCompactWriter(CompactStreamSerializer serializer, BufferObjectDataOutput out, Schema schema, boolean includeSchemaOnBinary) {
        this.serializer = serializer;
        this.out = out;
        this.schema = schema;
        if (schema.getNumberOfVariableSizeFields() != 0) {
            this.fieldOffsets = new int[schema.getNumberOfVariableSizeFields()];
            this.dataStartPosition = out.position() + 4;
            out.writeZeroBytes(schema.getFixedSizeFieldsLength() + 4);
        } else {
            this.fieldOffsets = null;
            this.dataStartPosition = out.position();
            out.writeZeroBytes(schema.getFixedSizeFieldsLength());
        }
        this.includeSchemaOnBinary = includeSchemaOnBinary;
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }

    public void end() {
        try {
            if (this.schema.getNumberOfVariableSizeFields() == 0) {
                return;
            }
            int position = this.out.position();
            int dataLength = position - this.dataStartPosition;
            this.writeOffsets(dataLength, this.fieldOffsets);
            this.out.writeInt(this.dataStartPosition - 4, dataLength);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    private void writeOffsets(int dataLength, int[] offsets) throws IOException {
        if (dataLength < 255) {
            for (int offset : offsets) {
                this.out.writeByte(offset);
            }
        } else if (dataLength < 65535) {
            for (int offset : offsets) {
                this.out.writeShort(offset);
            }
        } else {
            for (int offset : offsets) {
                this.out.writeInt(offset);
            }
        }
    }

    IllegalStateException illegalStateException(IOException cause) {
        return new IllegalStateException("IOException is not expected from BufferObjectDataOutput ", cause);
    }

    @Override
    public void writeBoolean(@Nonnull String fieldName, boolean value) {
        FieldDescriptor fieldDefinition = this.checkFieldDefinition(fieldName, FieldKind.BOOLEAN);
        int offsetInBytes = fieldDefinition.getOffset();
        byte offsetInBits = fieldDefinition.getBitOffset();
        int writeOffset = offsetInBytes + this.dataStartPosition;
        try {
            this.out.writeBooleanBit(writeOffset, offsetInBits, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeInt8(@Nonnull String fieldName, byte value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldKind.INT8);
        try {
            this.out.writeByte(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeInt16(@Nonnull String fieldName, short value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldKind.INT16);
        try {
            this.out.writeShort(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeInt32(@Nonnull String fieldName, int value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldKind.INT32);
        try {
            this.out.writeInt(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeInt64(@Nonnull String fieldName, long value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldKind.INT64);
        try {
            this.out.writeLong(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeFloat32(@Nonnull String fieldName, float value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldKind.FLOAT32);
        try {
            this.out.writeFloat(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeFloat64(@Nonnull String fieldName, double value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldKind.FLOAT64);
        try {
            this.out.writeDouble(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    protected <T> void writeVariableSizeField(@Nonnull String fieldName, @Nonnull FieldKind fieldKind, @Nullable T object, @Nonnull Writer<T> writer) {
        try {
            if (object == null) {
                this.setPositionAsNull(fieldName, fieldKind);
            } else {
                this.setPosition(fieldName, fieldKind);
                writer.write(this.out, object);
            }
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeString(@Nonnull String fieldName, @Nullable String str) {
        this.writeVariableSizeField(fieldName, FieldKind.STRING, str, ObjectDataOutput::writeString);
    }

    public void writeCompact(@Nonnull String fieldName, @Nullable Object value) {
        this.writeVariableSizeField(fieldName, FieldKind.COMPACT, value, (out, val) -> this.serializer.writeObject(out, val, this.includeSchemaOnBinary));
    }

    public void writeGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord value) {
        this.writeVariableSizeField(fieldName, FieldKind.COMPACT, value, (out, val) -> this.serializer.writeGenericRecord(out, (CompactGenericRecord)val, this.includeSchemaOnBinary));
    }

    @Override
    public void writeDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        this.writeVariableSizeField(fieldName, FieldKind.DECIMAL, value, IOUtil::writeBigDecimal);
    }

    @Override
    public void writeTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        this.writeVariableSizeField(fieldName, FieldKind.TIME, value, IOUtil::writeLocalTime);
    }

    @Override
    public void writeDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        this.writeVariableSizeField(fieldName, FieldKind.DATE, value, IOUtil::writeLocalDate);
    }

    @Override
    public void writeTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        this.writeVariableSizeField(fieldName, FieldKind.TIMESTAMP, value, IOUtil::writeLocalDateTime);
    }

    @Override
    public void writeTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        this.writeVariableSizeField(fieldName, FieldKind.TIMESTAMP_WITH_TIMEZONE, value, IOUtil::writeOffsetDateTime);
    }

    @Override
    public void writeArrayOfInt8(@Nonnull String fieldName, @Nullable byte[] values) {
        this.writeVariableSizeField(fieldName, FieldKind.ARRAY_OF_INT8, values, ObjectDataOutput::writeByteArray);
    }

    @Override
    public void writeArrayOfBoolean(@Nonnull String fieldName, @Nullable boolean[] values) {
        this.writeVariableSizeField(fieldName, FieldKind.ARRAY_OF_BOOLEAN, values, DefaultCompactWriter::writeBooleanBits);
    }

    @Override
    public void writeArrayOfInt32(@Nonnull String fieldName, @Nullable int[] values) {
        this.writeVariableSizeField(fieldName, FieldKind.ARRAY_OF_INT32, values, ObjectDataOutput::writeIntArray);
    }

    @Override
    public void writeArrayOfInt64(@Nonnull String fieldName, @Nullable long[] values) {
        this.writeVariableSizeField(fieldName, FieldKind.ARRAY_OF_INT64, values, ObjectDataOutput::writeLongArray);
    }

    @Override
    public void writeArrayOfFloat64(@Nonnull String fieldName, @Nullable double[] values) {
        this.writeVariableSizeField(fieldName, FieldKind.ARRAY_OF_FLOAT64, values, ObjectDataOutput::writeDoubleArray);
    }

    @Override
    public void writeArrayOfFloat32(@Nonnull String fieldName, @Nullable float[] values) {
        this.writeVariableSizeField(fieldName, FieldKind.ARRAY_OF_FLOAT32, values, ObjectDataOutput::writeFloatArray);
    }

    @Override
    public void writeArrayOfInt16(@Nonnull String fieldName, @Nullable short[] values) {
        this.writeVariableSizeField(fieldName, FieldKind.ARRAY_OF_INT16, values, ObjectDataOutput::writeShortArray);
    }

    @Override
    public void writeArrayOfString(@Nonnull String fieldName, @Nullable String[] values) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_STRING, values, ObjectDataOutput::writeString);
    }

    protected <T> void writeArrayOfVariableSize(@Nonnull String fieldName, @Nonnull FieldKind fieldKind, @Nullable T[] values, @Nonnull Writer<T> writer) {
        if (values == null) {
            this.setPositionAsNull(fieldName, fieldKind);
            return;
        }
        try {
            this.setPosition(fieldName, fieldKind);
            int dataLengthOffset = this.out.position();
            this.out.writeZeroBytes(4);
            int itemCount = values.length;
            this.out.writeInt(itemCount);
            int offset = this.out.position();
            int[] offsets = new int[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                if (values[i] != null) {
                    offsets[i] = this.out.position() - offset;
                    writer.write(this.out, values[i]);
                    continue;
                }
                offsets[i] = -1;
            }
            int dataLength = this.out.position() - offset;
            this.out.writeInt(dataLengthOffset, dataLength);
            this.writeOffsets(dataLength, offsets);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeArrayOfDecimal(@Nonnull String fieldName, @Nullable BigDecimal[] values) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_DECIMAL, values, IOUtil::writeBigDecimal);
    }

    @Override
    public void writeArrayOfTime(@Nonnull String fieldName, @Nullable LocalTime[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_TIME, value, IOUtil::writeLocalTime);
    }

    @Override
    public void writeArrayOfDate(@Nonnull String fieldName, @Nullable LocalDate[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_DATE, value, IOUtil::writeLocalDate);
    }

    @Override
    public void writeArrayOfTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_TIMESTAMP, value, IOUtil::writeLocalDateTime);
    }

    @Override
    public void writeArrayOfTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE, value, IOUtil::writeOffsetDateTime);
    }

    protected void setPositionAsNull(@Nonnull String fieldName, @Nonnull FieldKind fieldKind) {
        FieldDescriptor field2 = this.checkFieldDefinition(fieldName, fieldKind);
        int index = field2.getIndex();
        this.fieldOffsets[index] = -1;
    }

    protected void setPosition(@Nonnull String fieldName, @Nonnull FieldKind fieldKind) {
        FieldDescriptor field2 = this.checkFieldDefinition(fieldName, fieldKind);
        int pos = this.out.position();
        int fieldPosition = pos - this.dataStartPosition;
        int index = field2.getIndex();
        this.fieldOffsets[index] = fieldPosition;
    }

    private int getFixedSizeFieldPosition(@Nonnull String fieldName, @Nonnull FieldKind fieldKind) {
        FieldDescriptor fieldDefinition = this.checkFieldDefinition(fieldName, fieldKind);
        return fieldDefinition.getOffset() + this.dataStartPosition;
    }

    protected FieldDescriptor checkFieldDefinition(@Nonnull String fieldName, @Nonnull FieldKind kind) {
        FieldDescriptor field2 = this.schema.getField(fieldName);
        if (field2 == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + " for " + this.schema);
        }
        if (field2.getKind() != kind) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + " for " + this.schema);
        }
        return field2;
    }

    @Override
    public <T> void writeArrayOfCompact(@Nonnull String fieldName, @Nullable T[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_COMPACT, value, (out, val) -> this.serializer.writeObject(out, val, this.includeSchemaOnBinary));
    }

    public void writeArrayOfGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_COMPACT, value, (out, val) -> this.serializer.writeGenericRecord(out, (CompactGenericRecord)val, this.includeSchemaOnBinary));
    }

    @Override
    public void writeNullableInt8(@Nonnull String fieldName, @Nullable Byte value) {
        this.writeVariableSizeField(fieldName, FieldKind.NULLABLE_INT8, value, DataOutput::writeByte);
    }

    @Override
    public void writeNullableBoolean(@Nonnull String fieldName, @Nullable Boolean value) {
        this.writeVariableSizeField(fieldName, FieldKind.NULLABLE_BOOLEAN, value, DataOutput::writeBoolean);
    }

    @Override
    public void writeNullableInt16(@Nonnull String fieldName, @Nullable Short value) {
        this.writeVariableSizeField(fieldName, FieldKind.NULLABLE_INT16, value, DataOutput::writeShort);
    }

    @Override
    public void writeNullableInt32(@Nonnull String fieldName, @Nullable Integer value) {
        this.writeVariableSizeField(fieldName, FieldKind.NULLABLE_INT32, value, DataOutput::writeInt);
    }

    @Override
    public void writeNullableInt64(@Nonnull String fieldName, @Nullable Long value) {
        this.writeVariableSizeField(fieldName, FieldKind.NULLABLE_INT64, value, DataOutput::writeLong);
    }

    @Override
    public void writeNullableFloat32(@Nonnull String fieldName, @Nullable Float value) {
        this.writeVariableSizeField(fieldName, FieldKind.NULLABLE_FLOAT32, value, DataOutput::writeFloat);
    }

    @Override
    public void writeNullableFloat64(@Nonnull String fieldName, @Nullable Double value) {
        this.writeVariableSizeField(fieldName, FieldKind.NULLABLE_FLOAT64, value, DataOutput::writeDouble);
    }

    @Override
    public void writeArrayOfNullableInt8(@Nonnull String fieldName, @Nullable Byte[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT8, value, DataOutput::writeByte);
    }

    @Override
    public void writeArrayOfNullableBoolean(@Nonnull String fieldName, @Nullable Boolean[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN, value, DataOutput::writeBoolean);
    }

    @Override
    public void writeArrayOfNullableInt16(@Nonnull String fieldName, @Nullable Short[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT16, value, DataOutput::writeShort);
    }

    @Override
    public void writeArrayOfNullableInt32(@Nonnull String fieldName, @Nullable Integer[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT32, value, DataOutput::writeInt);
    }

    @Override
    public void writeArrayOfNullableInt64(@Nonnull String fieldName, @Nullable Long[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT64, value, DataOutput::writeLong);
    }

    @Override
    public void writeArrayOfNullableFloat32(@Nonnull String fieldName, @Nullable Float[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT32, value, DataOutput::writeFloat);
    }

    @Override
    public void writeArrayOfNullableFloat64(@Nonnull String fieldName, @Nullable Double[] value) {
        this.writeArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT64, value, DataOutput::writeDouble);
    }

    static void writeBooleanBits(BufferObjectDataOutput out, @Nullable boolean[] booleans) throws IOException {
        int len = booleans != null ? booleans.length : -1;
        out.writeInt(len);
        int position = out.position();
        if (len > 0) {
            int index = 0;
            out.writeZeroBytes(1);
            for (boolean v : booleans) {
                if (index == 8) {
                    index = 0;
                    out.writeZeroBytes(1);
                    ++position;
                }
                out.writeBooleanBit(position, index, v);
                ++index;
            }
        }
    }

    static interface Writer<T> {
        public void write(BufferObjectDataOutput var1, T var2) throws IOException;
    }
}

