/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import com.hazelcast.internal.config.override.ConfigNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ConfigNodeStateTracker {
    ConfigNodeStateTracker() {
    }

    Map<String, String> unprocessedNodes(ConfigNode node) {
        ArrayList<ConfigNode> nodes = new ArrayList<ConfigNode>();
        this.findAllUnreadNodes(nodes, node);
        return nodes.stream().map(this::process).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void findAllUnreadNodes(List<ConfigNode> acc2, ConfigNode node) {
        if (node.hasValue() && !node.isRead()) {
            acc2.add(node);
        }
        node.getChildren().values().forEach(c -> this.findAllUnreadNodes(acc2, (ConfigNode)c));
    }

    private Map.Entry<String, String> process(ConfigNode config) {
        ArrayList<String> configSegments = new ArrayList<String>();
        ConfigNode current = config;
        do {
            configSegments.add(current.getName());
        } while ((current = (ConfigNode)current.getParent().orElse(null)) != null);
        Collections.reverse(configSegments);
        return new AbstractMap.SimpleEntry<String, String>(String.join((CharSequence)".", configSegments), config.getValue());
    }
}

