/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.security.ICredentialsFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Properties;

public class KerberosIdentityConfig
implements IdentityConfig {
    private final CredentialsFactoryConfig factoryConfig = new CredentialsFactoryConfig("com.hazelcast.security.impl.KerberosCredentialsFactory");

    public String getSpn() {
        return this.factoryConfig.getProperties().getProperty("spn");
    }

    public KerberosIdentityConfig setSpn(String spn) {
        this.factoryConfig.getProperties().setProperty("spn", spn);
        return this;
    }

    public String getServiceNamePrefix() {
        return this.factoryConfig.getProperties().getProperty("serviceNamePrefix");
    }

    public KerberosIdentityConfig setServiceNamePrefix(String serviceNamePrefix) {
        this.factoryConfig.getProperties().setProperty("serviceNamePrefix", serviceNamePrefix);
        return this;
    }

    public String getRealm() {
        return this.factoryConfig.getProperties().getProperty("realm");
    }

    public KerberosIdentityConfig setRealm(String realm) {
        this.factoryConfig.getProperties().setProperty("realm", realm);
        return this;
    }

    public String getKeytabFile() {
        return this.factoryConfig.getProperties().getProperty("keytabFile");
    }

    public KerberosIdentityConfig setKeytabFile(String keytabFile) {
        this.factoryConfig.getProperties().setProperty("keytabFile", keytabFile);
        return this;
    }

    public String getPrincipal() {
        return this.factoryConfig.getProperties().getProperty("principal");
    }

    public KerberosIdentityConfig setPrincipal(String principal) {
        this.factoryConfig.getProperties().setProperty("principal", principal);
        return this;
    }

    public String getSecurityRealm() {
        return this.factoryConfig.getProperties().getProperty("securityRealm");
    }

    public KerberosIdentityConfig setSecurityRealm(String securityRealm) {
        this.factoryConfig.getProperties().setProperty("securityRealm", securityRealm);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Proper support in the config XML generator.")
    public Boolean getUseCanonicalHostname() {
        String strVal = this.factoryConfig.getProperties().getProperty("useCanonicalHostname");
        return strVal != null ? Boolean.valueOf(Boolean.parseBoolean(strVal)) : null;
    }

    public KerberosIdentityConfig setUseCanonicalHostname(Boolean useCanonicalHostname) {
        Properties props = this.factoryConfig.getProperties();
        if (useCanonicalHostname != null) {
            props.setProperty("useCanonicalHostname", useCanonicalHostname.toString());
        } else {
            props.remove("useCanonicalHostname");
        }
        return this;
    }

    @Override
    public ICredentialsFactory asCredentialsFactory(ClassLoader cl) {
        return this.factoryConfig.asCredentialsFactory(cl);
    }

    @Override
    public IdentityConfig copy() {
        return new KerberosIdentityConfig().setRealm(this.getRealm()).setSecurityRealm(this.getSecurityRealm()).setServiceNamePrefix(this.getServiceNamePrefix()).setSpn(this.getSpn());
    }

    public int hashCode() {
        return Objects.hash(this.factoryConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KerberosIdentityConfig other = (KerberosIdentityConfig)obj;
        return Objects.equals(this.factoryConfig, other.factoryConfig);
    }

    public String toString() {
        return "KerberosIdentityConfig [spn=" + this.getSpn() + ", serviceNamePrefix=" + this.getServiceNamePrefix() + ", realm=" + this.getRealm() + ", securityRealm=" + this.getSecurityRealm() + ", principal=" + this.getPrincipal() + ", keytabFile=" + this.getKeytabFile() + ", useCanonicalHostname=" + this.getUseCanonicalHostname() + "]";
    }
}

