/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.opeartion;

import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.OverviewInfo;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.serializable.ResourceDataSerializerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOverviewOperation
extends Operation
implements IdentifiedDataSerializable {
    private static final Logger log = LoggerFactory.getLogger(GetOverviewOperation.class);
    private OverviewInfo overviewInfo;
    private Map<String, String> tags;

    public GetOverviewOperation() {
    }

    public GetOverviewOperation(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        this.overviewInfo = GetOverviewOperation.getOverviewInfo(server, this.getNodeEngine(), this.tags);
    }

    @Override
    public Object getResponse() {
        return this.overviewInfo;
    }

    @Override
    public int getFactoryId() {
        return ResourceDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    public static OverviewInfo getOverviewInfo(SeaTunnelServer server, NodeEngine nodeEngine, Map<String, String> tags) {
        OverviewInfo overviewInfo = new OverviewInfo();
        ResourceManager resourceManager = server.getCoordinatorService().getResourceManager();
        List<SlotProfile> assignedSlots = resourceManager.getAssignedSlots(tags);
        List<SlotProfile> unassignedSlots = resourceManager.getUnassignedSlots(tags);
        IMap finishedJob = nodeEngine.getHazelcastInstance().getMap("engine_finishedJobState");
        overviewInfo.setTotalSlot(assignedSlots.size() + unassignedSlots.size());
        overviewInfo.setUnassignedSlot(unassignedSlots.size());
        overviewInfo.setWorkers(resourceManager.workerCount(tags));
        overviewInfo.setRunningJobs(nodeEngine.getHazelcastInstance().getMap("engine_runningJobInfo").size());
        overviewInfo.setFailedJobs(finishedJob.values().stream().filter(jobState -> jobState.getJobStatus().name().equals(JobStatus.FAILED.toString())).count());
        overviewInfo.setCancelledJobs(finishedJob.values().stream().filter(jobState -> jobState.getJobStatus().name().equals(JobStatus.CANCELED.toString())).count());
        overviewInfo.setFinishedJobs(finishedJob.values().stream().filter(jobState -> jobState.getJobStatus().name().equals(JobStatus.FINISHED.toString())).count());
        return overviewInfo;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.tags);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.tags = (Map)in.readObject();
    }
}

