/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyRegistry;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

class DistributedObjectCounterCollector
implements MetricsCollector {
    private static final Map<String, PhoneHomeMetrics[]> SERVICE_NAME_TO_METRIC_NAME = MapUtil.createHashMap(12);

    DistributedObjectCounterCollector() {
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer2) {
        InternalProxyService proxyService = node.nodeEngine.getProxyService();
        Map<String, Long> objectsPerService = proxyService.getAllDistributedObjects().stream().filter(obj -> ProxyRegistry.INTERNAL_OBJECTS_PREFIXES.stream().noneMatch(prefix -> obj.getName().startsWith((String)prefix))).filter(obj -> SERVICE_NAME_TO_METRIC_NAME.containsKey(obj.getServiceName())).collect(Collectors.groupingBy(DistributedObject::getServiceName, Collectors.counting()));
        SERVICE_NAME_TO_METRIC_NAME.forEach((serviceName, metricNames) -> {
            metricsConsumer2.accept(metricNames[0], String.valueOf(objectsPerService.getOrDefault(serviceName, 0L)));
            metricsConsumer2.accept(metricNames[1], String.valueOf(proxyService.getCreatedCount((String)serviceName)));
        });
    }

    static {
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:mapService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_MAPS, PhoneHomeMetrics.COUNT_OF_MAPS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:setService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_SETS, PhoneHomeMetrics.COUNT_OF_SETS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:queueService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_QUEUES, PhoneHomeMetrics.COUNT_OF_QUEUES_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:multiMapService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_MULTIMAPS, PhoneHomeMetrics.COUNT_OF_MULTIMAPS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:listService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_LISTS, PhoneHomeMetrics.COUNT_OF_LISTS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:ringbufferService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_RING_BUFFERS, PhoneHomeMetrics.COUNT_OF_RING_BUFFERS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:cacheService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_CACHES, PhoneHomeMetrics.COUNT_OF_CACHES_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:topicService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_TOPICS, PhoneHomeMetrics.COUNT_OF_TOPICS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:replicatedMapService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_REPLICATED_MAPS, PhoneHomeMetrics.COUNT_OF_REPLICATED_MAPS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:cardinalityEstimatorService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_CARDINALITY_ESTIMATORS, PhoneHomeMetrics.COUNT_OF_CARDINALITY_ESTIMATORS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:PNCounterService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_PN_COUNTERS, PhoneHomeMetrics.COUNT_OF_PN_COUNTERS_ALL_TIME});
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:flakeIdGeneratorService", new PhoneHomeMetrics[]{PhoneHomeMetrics.COUNT_OF_FLAKE_ID_GENERATORS, PhoneHomeMetrics.COUNT_OF_FLAKE_ID_GENERATORS_ALL_TIME});
    }
}

