/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointType;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class CheckpointBarrier
implements Barrier,
Serializable {
    private final long id;
    private final long timestamp;
    private final CheckpointType checkpointType;

    public CheckpointBarrier(long id, long timestamp, CheckpointType checkpointType) {
        this.id = id;
        this.timestamp = timestamp;
        this.checkpointType = Preconditions.checkNotNull(checkpointType);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean snapshot() {
        return true;
    }

    @Override
    public boolean prepareClose() {
        return this.checkpointType.isFinalCheckpoint();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.timestamp, this.checkpointType});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != CheckpointBarrier.class) {
            return false;
        }
        CheckpointBarrier that = (CheckpointBarrier)other;
        return that.id == this.id && that.timestamp == this.timestamp && this.checkpointType.equals((Object)that.checkpointType);
    }

    public String toString() {
        return String.format("CheckpointBarrier %d @ %d Options: %s", new Object[]{this.id, this.timestamp, this.checkpointType});
    }

    public boolean isAuto() {
        return this.checkpointType.isAuto();
    }
}

