/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MBeanInfoBuilder;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsConfig;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.util.Contracts;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.Time;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.hadoop.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricsSourceAdapter
implements DynamicMBean {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSourceAdapter.class);
    private final String prefix;
    private final String name;
    private final MetricsSource source;
    private final MetricsFilter recordFilter;
    private final MetricsFilter metricFilter;
    private final HashMap<String, Attribute> attrCache;
    private final MBeanInfoBuilder infoBuilder;
    private final Iterable<MetricsTag> injectedTags;
    private boolean lastRecsCleared;
    private long jmxCacheTS = 0L;
    private long jmxCacheTTL;
    private MBeanInfo infoCache;
    private ObjectName mbeanName;
    private final boolean startMBeans;

    MetricsSourceAdapter(String prefix, String name, String description, MetricsSource source, Iterable<MetricsTag> injectedTags, MetricsFilter recordFilter, MetricsFilter metricFilter, long jmxCacheTTL, boolean startMBeans) {
        this.prefix = Preconditions.checkNotNull(prefix, "prefix");
        this.name = Preconditions.checkNotNull(name, "name");
        this.source = Preconditions.checkNotNull(source, "source");
        this.attrCache = Maps.newHashMap();
        this.infoBuilder = new MBeanInfoBuilder(name, description);
        this.injectedTags = injectedTags;
        this.recordFilter = recordFilter;
        this.metricFilter = metricFilter;
        this.jmxCacheTTL = Contracts.checkArg(jmxCacheTTL, jmxCacheTTL > 0L, (Object)"jmxCacheTTL");
        this.startMBeans = startMBeans;
        this.lastRecsCleared = true;
    }

    MetricsSourceAdapter(String prefix, String name, String description, MetricsSource source, Iterable<MetricsTag> injectedTags, long period, MetricsConfig conf) {
        this(prefix, name, description, source, injectedTags, conf.getFilter("record.filter"), conf.getFilter("metric.filter"), period + 1L, conf.getBoolean("source.start_mbeans", true));
    }

    void start() {
        if (this.startMBeans) {
            this.startMBeans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        this.updateJmxCache();
        MetricsSourceAdapter metricsSourceAdapter = this;
        synchronized (metricsSourceAdapter) {
            Attribute a = this.attrCache.get(attribute);
            if (a == null) {
                throw new AttributeNotFoundException(attribute + " not found");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(attribute + ": " + a);
            }
            return a.getValue();
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Metrics are read-only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList getAttributes(String[] attributes) {
        this.updateJmxCache();
        MetricsSourceAdapter metricsSourceAdapter = this;
        synchronized (metricsSourceAdapter) {
            AttributeList ret = new AttributeList();
            for (String key : attributes) {
                Attribute attr = this.attrCache.get(key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(key + ": " + attr);
                }
                ret.add(attr);
            }
            return ret;
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("Metrics are read-only.");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        this.updateJmxCache();
        return this.infoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJmxCache() {
        boolean getAllMetrics = false;
        MetricsSourceAdapter metricsSourceAdapter = this;
        synchronized (metricsSourceAdapter) {
            if (Time.now() - this.jmxCacheTS >= this.jmxCacheTTL) {
                this.jmxCacheTS = Time.now() + this.jmxCacheTTL;
                if (this.lastRecsCleared) {
                    getAllMetrics = true;
                    this.lastRecsCleared = false;
                }
            } else {
                return;
            }
        }
        Iterable<MetricsRecordImpl> lastRecs = null;
        if (getAllMetrics) {
            lastRecs = this.getMetrics(new MetricsCollectorImpl(), true);
        }
        MetricsSourceAdapter metricsSourceAdapter2 = this;
        synchronized (metricsSourceAdapter2) {
            if (lastRecs != null) {
                this.updateAttrCache(lastRecs);
                this.updateInfoCache(lastRecs);
            }
            this.jmxCacheTS = Time.now();
            this.lastRecsCleared = true;
        }
    }

    Iterable<MetricsRecordImpl> getMetrics(MetricsCollectorImpl builder, boolean all) {
        builder.setRecordFilter(this.recordFilter).setMetricFilter(this.metricFilter);
        try {
            this.source.getMetrics(builder, all);
        }
        catch (Exception e) {
            LOG.error("Error getting metrics from source " + this.name, (Throwable)e);
        }
        for (MetricsRecordBuilderImpl rb : builder) {
            for (MetricsTag t : this.injectedTags) {
                rb.add(t);
            }
        }
        return builder.getRecords();
    }

    synchronized void stop() {
        this.stopMBeans();
    }

    synchronized void startMBeans() {
        if (this.mbeanName != null) {
            LOG.warn("MBean " + this.name + " already initialized!");
            LOG.debug("Stacktrace: ", new Throwable());
            return;
        }
        this.mbeanName = MBeans.register(this.prefix, this.name, this);
        LOG.debug("MBean for source " + this.name + " registered.");
    }

    synchronized void stopMBeans() {
        if (this.mbeanName != null) {
            MBeans.unregister(this.mbeanName);
            this.mbeanName = null;
        }
    }

    @VisibleForTesting
    ObjectName getMBeanName() {
        return this.mbeanName;
    }

    @VisibleForTesting
    long getJmxCacheTTL() {
        return this.jmxCacheTTL;
    }

    private void updateInfoCache(Iterable<MetricsRecordImpl> lastRecs) {
        Preconditions.checkNotNull(lastRecs, "LastRecs should not be null");
        LOG.debug("Updating info cache...");
        this.infoCache = this.infoBuilder.reset(lastRecs).get();
        LOG.debug("Done");
    }

    private int updateAttrCache(Iterable<MetricsRecordImpl> lastRecs) {
        Preconditions.checkNotNull(lastRecs, "LastRecs should not be null");
        LOG.debug("Updating attr cache...");
        int recNo = 0;
        int numMetrics = 0;
        for (MetricsRecordImpl record : lastRecs) {
            for (MetricsTag t : record.tags()) {
                this.setAttrCacheTag(t, recNo);
                ++numMetrics;
            }
            for (AbstractMetric m3 : record.metrics()) {
                this.setAttrCacheMetric(m3, recNo);
                ++numMetrics;
            }
            ++recNo;
        }
        LOG.debug("Done. # tags & metrics=" + numMetrics);
        return numMetrics;
    }

    private static String tagName(String name, int recNo) {
        StringBuilder sb = new StringBuilder(name.length() + 16);
        sb.append("tag.").append(name);
        if (recNo > 0) {
            sb.append('.').append(recNo);
        }
        return sb.toString();
    }

    private void setAttrCacheTag(MetricsTag tag, int recNo) {
        String key = MetricsSourceAdapter.tagName(tag.name(), recNo);
        this.attrCache.put(key, new Attribute(key, tag.value()));
    }

    private static String metricName(String name, int recNo) {
        if (recNo == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length() + 12);
        sb.append(name);
        if (recNo > 0) {
            sb.append('.').append(recNo);
        }
        return sb.toString();
    }

    private void setAttrCacheMetric(AbstractMetric metric, int recNo) {
        String key = MetricsSourceAdapter.metricName(metric.name(), recNo);
        this.attrCache.put(key, new Attribute(key, metric.value()));
    }

    String name() {
        return this.name;
    }

    MetricsSource source() {
        return this.source;
    }
}

