/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.group.queue.disruptor;

import com.lmax.disruptor.EventHandler;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.transform.Collector;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.flow.IntermediateQueueFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.group.queue.disruptor.RecordEvent;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class RecordEventHandler
implements EventHandler<RecordEvent> {
    private final SeaTunnelTask runningTask;
    private final Collector<Record<?>> collector;
    private final IntermediateQueueFlowLifeCycle intermediateQueueFlowLifeCycle;

    public RecordEventHandler(SeaTunnelTask runningTask, Collector<Record<?>> collector, IntermediateQueueFlowLifeCycle intermediateQueueFlowLifeCycle) {
        this.runningTask = runningTask;
        this.collector = collector;
        this.intermediateQueueFlowLifeCycle = intermediateQueueFlowLifeCycle;
    }

    @Override
    public void onEvent(RecordEvent recordEvent, long sequence, boolean endOfBatch) throws Exception {
        this.handleRecord(recordEvent.getRecord(), this.collector);
    }

    private void handleRecord(Record<?> record, Collector<Record<?>> collector) throws Exception {
        if (record != null) {
            if (record.getData() instanceof Barrier) {
                CheckpointBarrier barrier = (CheckpointBarrier)record.getData();
                this.runningTask.ack(barrier);
                if (barrier.prepareClose()) {
                    this.intermediateQueueFlowLifeCycle.setPrepareClose(true);
                }
            } else if (this.intermediateQueueFlowLifeCycle.getPrepareClose().booleanValue()) {
                return;
            }
            collector.collect(record);
        }
    }
}

