/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.flowcontrol;

import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public final class FlowControlStrategy {
    private final int bytesPerSecond;
    private final int countPreSecond;

    FlowControlStrategy(int bytesPerSecond, int countPreSecond) {
        if (bytesPerSecond <= 0 || countPreSecond <= 0) {
            throw new IllegalArgumentException("bytesPerSecond and countPreSecond must be positive");
        }
        this.bytesPerSecond = bytesPerSecond;
        this.countPreSecond = countPreSecond;
    }

    public int getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public int getCountPreSecond() {
        return this.countPreSecond;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static FlowControlStrategy of(int bytesPerSecond, int countPreSecond) {
        return FlowControlStrategy.builder().bytesPerSecond(bytesPerSecond).countPerSecond(countPreSecond).build();
    }

    public static FlowControlStrategy ofBytes(int bytesPerSecond) {
        return FlowControlStrategy.builder().bytesPerSecond(bytesPerSecond).build();
    }

    public static FlowControlStrategy ofCount(int countPreSecond) {
        return FlowControlStrategy.builder().countPerSecond(countPreSecond).build();
    }

    public static FlowControlStrategy fromMap(Map<String, Object> envOption) {
        Builder builder = FlowControlStrategy.builder();
        if (envOption == null || envOption.isEmpty()) {
            return builder.build();
        }
        Object bytePerSecond = envOption.get(EnvCommonOptions.READ_LIMIT_BYTES_PER_SECOND.key());
        Object countPerSecond = envOption.get(EnvCommonOptions.READ_LIMIT_ROW_PER_SECOND.key());
        Optional.ofNullable(bytePerSecond).ifPresent(bps -> builder.bytesPerSecond(Integer.parseInt(bps.toString())));
        Optional.ofNullable(countPerSecond).ifPresent(cps -> builder.countPerSecond(Integer.parseInt(cps.toString())));
        return builder.build();
    }

    public static FlowControlStrategy fromConfig(Config envConfig) {
        Builder builder = FlowControlStrategy.builder();
        if (envConfig.hasPath(EnvCommonOptions.READ_LIMIT_BYTES_PER_SECOND.key())) {
            builder.bytesPerSecond(envConfig.getInt(EnvCommonOptions.READ_LIMIT_BYTES_PER_SECOND.key()));
        }
        if (envConfig.hasPath(EnvCommonOptions.READ_LIMIT_ROW_PER_SECOND.key())) {
            builder.countPerSecond(envConfig.getInt(EnvCommonOptions.READ_LIMIT_ROW_PER_SECOND.key()));
        }
        return builder.build();
    }

    public static class Builder {
        private int bytesPerSecond = Integer.MAX_VALUE;
        private int countPreSecond = Integer.MAX_VALUE;

        private Builder() {
        }

        public Builder bytesPerSecond(int bytesPerSecond) {
            this.bytesPerSecond = bytesPerSecond;
            return this;
        }

        public Builder countPerSecond(int countPreSecond) {
            this.countPreSecond = countPreSecond;
            return this;
        }

        public FlowControlStrategy build() {
            return new FlowControlStrategy(this.bytesPerSecond, this.countPreSecond);
        }
    }
}

