/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.BiConsumer;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
class CloudInfoCollector
implements MetricsCollector {
    private static final String AWS_ENDPOINT = "http://169.254.169.254/latest/meta-data";
    private static final String AZURE_ENDPOINT = " http://169.254.169.254/metadata/instance/compute?api-version=2018-02-01";
    private static final String GCP_ENDPOINT = " http://metadata.google.internal";
    private static final Path KUBERNETES_TOKEN_PATH = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]);
    private static final Path DOCKER_FILE_PATH = Paths.get("/.dockerenv", new String[0]);
    private final String awsEndpoint;
    private final String azureEndpoint;
    private final String gcpEndpoint;
    private final Path kubernetesTokenPath;
    private final Path dockerFilePath;
    private volatile Map<PhoneHomeMetrics, String> environmentInfo;

    CloudInfoCollector() {
        this(AWS_ENDPOINT, AZURE_ENDPOINT, GCP_ENDPOINT, KUBERNETES_TOKEN_PATH, DOCKER_FILE_PATH);
    }

    CloudInfoCollector(String awsEndPoint, String azureEndPoint, String gcpEndPoint, Path kubernetesTokenpath, Path dockerFilepath) {
        this.awsEndpoint = awsEndPoint;
        this.azureEndpoint = azureEndPoint;
        this.gcpEndpoint = gcpEndPoint;
        this.kubernetesTokenPath = kubernetesTokenpath;
        this.dockerFilePath = dockerFilepath;
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer2) {
        if (this.environmentInfo != null) {
            this.environmentInfo.forEach(metricsConsumer2);
            return;
        }
        Map<PhoneHomeMetrics, String> info = MapUtil.createHashMap(2);
        if (MetricsCollector.fetchWebService(this.awsEndpoint)) {
            info.put(PhoneHomeMetrics.CLOUD, "A");
        } else if (MetricsCollector.fetchWebService(this.azureEndpoint)) {
            info.put(PhoneHomeMetrics.CLOUD, "Z");
        } else if (MetricsCollector.fetchWebService(this.gcpEndpoint)) {
            info.put(PhoneHomeMetrics.CLOUD, "G");
        } else {
            info.put(PhoneHomeMetrics.CLOUD, "N");
        }
        try {
            this.dockerFilePath.toRealPath(new LinkOption[0]);
            try {
                this.kubernetesTokenPath.toRealPath(new LinkOption[0]);
                info.put(PhoneHomeMetrics.DOCKER, "K");
            }
            catch (IOException e) {
                info.put(PhoneHomeMetrics.DOCKER, "D");
            }
        }
        catch (IOException e) {
            info.put(PhoneHomeMetrics.DOCKER, "N");
        }
        this.environmentInfo = info;
        this.environmentInfo.forEach(metricsConsumer2);
    }
}

