/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql;

import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.sql.SQLEngine;
import org.apache.seatunnel.transform.sql.zeta.ZetaSQLEngine;

public class SQLEngineFactory {
    public static SQLEngine getSQLEngine(EngineType engineType) {
        switch (engineType) {
            case ZETA: 
            case INTERNAL: {
                return new ZetaSQLEngine();
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported SQL engine type: %s", new Object[]{engineType}));
    }

    public static enum EngineType {
        ZETA,
        INTERNAL;

    }
}

